/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pixelshot.config;

import fuzs.puzzleslib.api.config.v3.Config;
import fuzs.puzzleslib.api.config.v3.ConfigCore;

public class ClientConfig
implements ConfigCore {
    @Config
    public final OrthographicCamera orthographicCamera = new OrthographicCamera();
    @Config
    public final HighResolutionScreenshots highResolutionScreenshots = new HighResolutionScreenshots();

    public static class OrthographicCamera
    implements ConfigCore {
        @Config(description={"Default zoom level when opening the orthographic camera."})
        @Config.DoubleRange(min=0.10000000149011612, max=500.0)
        public double initialZoomLevel = 8.0;
        @Config(description={"Default rotation in degrees when opening the orthographic camera for the horizontal axis."})
        @Config.DoubleRange(min=-90.0, max=90.0)
        public double initialXRotation = 30.0;
        @Config(description={"Default rotation in degrees when opening the orthographic camera for the vertical axis."})
        @Config.DoubleRange(min=-180.0, max=180.0)
        public double initialYRotation = 135.0;
        @Config(description={"Default setting for player rendering when opening the orthographic camera."})
        public boolean initialPlayerRendering = true;
    }

    public static class HighResolutionScreenshots
    implements ConfigCore {
        @Config(description={"Horizontal amount of pixels for high resolution screenshots.", "Largest allowed value depends on current system and will crash when unsupported. If that happens enable tiled rendering."})
        @Config.IntRange(min=1)
        public int imageWidth = 3840;
        @Config(description={"Vertical amount of pixels for high resolution screenshots.", "Largest allowed value depends on current system and will crash when unsupported. If that happens enable tiled rendering."})
        @Config.IntRange(min=1)
        public int imageHeight = 2160;
        public boolean tiledRendering = false;
        @Config(description={"Image width and height for panoramic screenshot tiles. Should ideally be two to the power of X."})
        @Config.IntRange(min=1)
        public int panoramicResolution = 1024;
    }
}

