/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pixelshot.client.handler;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlUtil;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.pixelshot.Pixelshot;
import fuzs.pixelshot.client.handler.OrthoViewHandler;
import fuzs.pixelshot.config.ClientConfig;
import fuzs.puzzleslib.api.client.core.v1.context.KeyMappingsContext;
import fuzs.puzzleslib.api.client.key.v1.KeyActivationContext;
import fuzs.puzzleslib.api.client.key.v1.KeyMappingHelper;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import java.io.File;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class ScreenshotHandler {
    public static final ScreenshotHandler INSTANCE = new ScreenshotHandler();
    public static final MutableComponent COMPONENT_SCREENSHOT_TAKE = Component.translatable((String)"screenshot.take");
    public static final KeyMapping KEY_HIGH_RESOLUTION_SCREENSHOT = KeyMappingHelper.registerKeyMapping((ResourceLocation)Pixelshot.id("high_resolution_screenshot"), (int)298);
    public static final KeyMapping KEY_PANORAMIC_SCREENSHOT = KeyMappingHelper.registerUnboundKeyMapping((ResourceLocation)Pixelshot.id("panoramic_screenshot"));
    private boolean hugeScreenshotMode;

    public static void onRegisterKeyMappings(KeyMappingsContext context) {
        context.registerKeyMapping(KEY_HIGH_RESOLUTION_SCREENSHOT, KeyActivationContext.GAME);
        context.registerKeyMapping(KEY_PANORAMIC_SCREENSHOT, KeyActivationContext.GAME);
    }

    public boolean isHugeScreenshotMode() {
        return this.hugeScreenshotMode;
    }

    private void setHugeScreenshotMode(boolean hugeScreenshotMode) {
        this.hugeScreenshotMode = hugeScreenshotMode;
        GameRenderer gameRenderer = Minecraft.getInstance().gameRenderer;
        gameRenderer.setRenderBlockOutline(!hugeScreenshotMode);
        gameRenderer.setRenderHand(!hugeScreenshotMode);
    }

    public EventResult onKeyPress(int keyCode, int scanCode, int action, int modifiers) {
        Minecraft minecraft = Minecraft.getInstance();
        if (action == 1 && minecraft.screen == null) {
            if (KEY_HIGH_RESOLUTION_SCREENSHOT.matches(keyCode, scanCode)) {
                int windowWidth = minecraft.getWindow().getWidth();
                int windowHeight = minecraft.getWindow().getHeight();
                int imageWidth = ((ClientConfig)Pixelshot.CONFIG.get(ClientConfig.class)).highResolutionScreenshots.imageWidth;
                int imageHeight = ((ClientConfig)Pixelshot.CONFIG.get(ClientConfig.class)).highResolutionScreenshots.imageHeight;
                Consumer<Component> consumer = component -> minecraft.execute(() -> minecraft.gui.getChat().addMessage(component));
                this.setHugeScreenshotMode(true);
                if (((ClientConfig)Pixelshot.CONFIG.get(ClientConfig.class)).highResolutionScreenshots.tiledRendering) {
                    consumer.accept(this.grabHugeScreenshot(minecraft, windowWidth, windowHeight, imageWidth, imageHeight));
                } else {
                    this.grabHugeScreenshot(minecraft, windowWidth, windowHeight, imageWidth, imageHeight, consumer);
                }
                this.setHugeScreenshotMode(false);
            }
            if (KEY_PANORAMIC_SCREENSHOT.matches(keyCode, scanCode) && !OrthoViewHandler.INSTANCE.isActive()) {
                int panoramicResolution = ((ClientConfig)Pixelshot.CONFIG.get(ClientConfig.class)).highResolutionScreenshots.panoramicResolution;
                Component component2 = this.grabPanoramicScreenshot(minecraft, minecraft.gameDirectory, panoramicResolution, panoramicResolution);
                minecraft.execute(() -> minecraft.gui.getChat().addMessage(component2));
            }
        }
        return EventResult.PASS;
    }

    private Component grabHugeScreenshot(Minecraft minecraft, int columnWidth, int rowHeight, int width, int height) {
        try {
            Screenshot screenshot = new Screenshot(minecraft.gameDirectory, width, height, rowHeight);
            float f = (float)width / (float)columnWidth;
            float g = (float)height / (float)rowHeight;
            float h = f > g ? f : g;
            for (int i = (height - 1) / rowHeight * rowHeight; i >= 0; i -= rowHeight) {
                ByteBuffer byteBuffer = GlUtil.allocateMemory((int)(columnWidth * rowHeight * 3));
                for (int j = 0; j < width; j += columnWidth) {
                    float k = (float)(width - columnWidth) / 2.0f * 2.0f - (float)(j * 2);
                    float l = (float)(height - rowHeight) / 2.0f * 2.0f - (float)(i * 2);
                    minecraft.gameRenderer.renderZoomed(h, k /= (float)columnWidth, l /= (float)rowHeight);
                    byteBuffer.clear();
                    RenderSystem.pixelStore((int)3333, (int)1);
                    RenderSystem.pixelStore((int)3317, (int)1);
                    RenderSystem.readPixels((int)0, (int)0, (int)columnWidth, (int)rowHeight, (int)32992, (int)5121, (ByteBuffer)byteBuffer);
                    screenshot.addRegion(byteBuffer, j, i, columnWidth, rowHeight);
                }
                screenshot.saveRow();
                GlUtil.freeMemory((Buffer)byteBuffer);
            }
            File file = screenshot.close();
            MutableComponent component = Component.literal((String)file.getName()).withStyle(ChatFormatting.UNDERLINE).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, file.getAbsolutePath())));
            return Component.translatable((String)"screenshot.success", (Object[])new Object[]{component});
        }
        catch (Exception var15) {
            Pixelshot.LOGGER.warn("Couldn't save screenshot", (Throwable)var15);
            return Component.translatable((String)"screenshot.failure", (Object[])new Object[]{var15.getMessage()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grabHugeScreenshot(Minecraft minecraft, int windowWidth, int windowHeight, int imageWidth, int imageHeight, Consumer<Component> consumer) {
        Window window = minecraft.getWindow();
        RenderTarget renderTarget = minecraft.getMainRenderTarget();
        try {
            window.setWidth(imageWidth);
            window.setHeight(imageHeight);
            renderTarget.resize(imageWidth, imageHeight);
            renderTarget.bindWrite(true);
            minecraft.gameRenderer.renderLevel(DeltaTracker.ONE);
            String screenshotName = ScreenshotHandler.getFile(minecraft.gameDirectory, "huge_", ".png").getName();
            Screenshot.grab((File)minecraft.gameDirectory, (String)screenshotName, (RenderTarget)renderTarget, consumer);
            consumer.accept((Component)COMPONENT_SCREENSHOT_TAKE);
        }
        finally {
            window.setWidth(windowWidth);
            window.setHeight(windowHeight);
            renderTarget.resize(windowWidth, windowHeight);
            renderTarget.bindWrite(true);
        }
    }

    private void setPanoramicMode(boolean panoramicMode) {
        GameRenderer gameRenderer = Minecraft.getInstance().gameRenderer;
        gameRenderer.setRenderBlockOutline(!panoramicMode);
        gameRenderer.setPanoramicMode(panoramicMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Component grabPanoramicScreenshot(Minecraft minecraft, File gameDirectory, int width, int height) {
        Window window = minecraft.getWindow();
        LocalPlayer player = minecraft.player;
        int windowWidth = window.getWidth();
        int windowHeight = window.getHeight();
        RenderTarget renderTarget = minecraft.getMainRenderTarget();
        float xRot = player.getXRot();
        float yRot = player.getYRot();
        float xRotO = player.xRotO;
        float yRotO = player.yRotO;
        try {
            this.setPanoramicMode(true);
            window.setWidth(width);
            window.setHeight(height);
            renderTarget.resize(width, height);
            File file = ScreenshotHandler.getFile(new File(minecraft.gameDirectory, "screenshots"), "", "");
            file.mkdirs();
            String fileName = file.getName();
            for (int i = 0; i < 6; ++i) {
                switch (i) {
                    case 0: {
                        player.setYRot(yRot);
                        player.setXRot(0.0f);
                        break;
                    }
                    case 1: {
                        player.setYRot((yRot + 90.0f) % 360.0f);
                        player.setXRot(0.0f);
                        break;
                    }
                    case 2: {
                        player.setYRot((yRot + 180.0f) % 360.0f);
                        player.setXRot(0.0f);
                        break;
                    }
                    case 3: {
                        player.setYRot((yRot - 90.0f) % 360.0f);
                        player.setXRot(0.0f);
                        break;
                    }
                    case 4: {
                        player.setYRot(yRot);
                        player.setXRot(-90.0f);
                        break;
                    }
                    case 5: {
                        player.setYRot(yRot);
                        player.setXRot(90.0f);
                    }
                }
                player.yRotO = player.getYRot();
                player.xRotO = player.getXRot();
                renderTarget.bindWrite(true);
                minecraft.gameRenderer.renderLevel(DeltaTracker.ONE);
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Screenshot.grab((File)gameDirectory, (String)(fileName + File.separator + "panorama_" + i + ".png"), (RenderTarget)renderTarget, component -> {});
            }
            MutableComponent component2 = Component.literal((String)fileName).withStyle(ChatFormatting.UNDERLINE).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, file.getAbsolutePath())));
            MutableComponent mutableComponent = Component.translatable((String)"screenshot.success", (Object[])new Object[]{component2});
            return mutableComponent;
        }
        catch (Exception exception) {
            Pixelshot.LOGGER.error("Couldn't save image", (Throwable)exception);
            MutableComponent mutableComponent = Component.translatable((String)"screenshot.failure", (Object[])new Object[]{exception.getMessage()});
            return mutableComponent;
        }
        finally {
            player.setXRot(xRot);
            player.setYRot(yRot);
            player.xRotO = xRotO;
            player.yRotO = yRotO;
            window.setWidth(windowWidth);
            window.setHeight(windowHeight);
            renderTarget.resize(windowWidth, windowHeight);
            this.setPanoramicMode(false);
            renderTarget.bindWrite(true);
        }
    }

    private static File getFile(File gameDirectory, String filePrefix, String filePostfix) {
        String fileName = filePrefix + Util.getFilenameFormattedDateTime();
        int i = 1;
        File file;
        while ((file = new File(gameDirectory, fileName + (String)(i == 1 ? "" : "_" + i) + filePostfix)).exists()) {
            ++i;
        }
        return file;
    }
}

