/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pixelshot.client.gui.screens;

import fuzs.pixelshot.client.gui.screens.AbstractCameraScreen;
import fuzs.pixelshot.client.handler.OrthoViewHandler;
import fuzs.puzzleslib.api.client.gui.v2.components.SpritelessImageButton;
import fuzs.puzzleslib.api.client.gui.v2.components.tooltip.TooltipBuilder;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_333;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7842;

public class EditBoxCameraScreen
extends AbstractCameraScreen {
    static final String VALID_NUMBER_PATTERN = "[\\d+\\-.]*";
    static final class_5250 COMPONENT_ZOOM = class_2561.method_43469((String)"pixelshot.zoom", (Object[])new Object[]{""});
    static final class_5250 COMPONENT_X_ROT = class_2561.method_43469((String)"pixelshot.x_rot", (Object[])new Object[]{""});
    static final class_5250 COMPONENT_Y_ROT = class_2561.method_43469((String)"pixelshot.y_rot", (Object[])new Object[]{""});

    public EditBoxCameraScreen(class_2561 title, OrthoViewHandler handler) {
        super(AbstractCameraScreen.Type.EDIT_BOX, title, handler);
    }

    @Override
    void addControlRow(AbstractCameraScreen.OrthoComponent component, int rowHeight, Collection<class_339> widgets) {
        super.addControlRow(component, rowHeight, widgets);
        Consumer<Float> consumer = value -> component.consumer.accept(this.handler, (Float)value);
        Supplier<Float> supplier = () -> component.supplier.apply(this.handler);
        int maxWidth = EditBoxCameraScreen.getMaxComponentWidth(this.field_22793);
        int n = this.field_22789 / 2 - 154 + 67 - maxWidth / 2;
        Objects.requireNonNull(this.field_22793);
        widgets.add((class_339)new class_7842(n, rowHeight + 5, maxWidth, 9, component.component, this.field_22793));
        class_342 editBox = new class_342(this.field_22793, this.field_22789 / 2 - 20, rowHeight, 150, 20, class_333.field_18967);
        editBox.method_1890(string -> string.matches(VALID_NUMBER_PATTERN));
        editBox.method_1852(String.valueOf(OrthoViewHandler.roundValue(supplier.get().floatValue())));
        editBox.method_1863(string -> {
            try {
                consumer.accept(Float.valueOf(Float.parseFloat(string)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        widgets.add((class_339)editBox);
        SpritelessImageButton plusButton = new SpritelessImageButton(this.field_22789 / 2 + 134, rowHeight, 20, 10, 0, 0, WIDGETS_LOCATION, button -> {
            consumer.accept(Float.valueOf(((Float)supplier.get()).floatValue() + EditBoxCameraScreen.getCurrentIncrement()));
            editBox.method_1852(String.valueOf(OrthoViewHandler.roundValue(((Float)supplier.get()).floatValue())));
        }).setDrawBackground().setTextureLayout(SpritelessImageButton.SINGLE_TEXTURE_LAYOUT);
        TooltipBuilder.create().setLines(EditBoxCameraScreen.getCurrentTooltipLines('+')).build((class_339)plusButton);
        widgets.add((class_339)plusButton);
        SpritelessImageButton minusButton = new SpritelessImageButton(this.field_22789 / 2 + 134, rowHeight + 10, 20, 10, 20, 0, WIDGETS_LOCATION, button -> {
            consumer.accept(Float.valueOf(((Float)supplier.get()).floatValue() - EditBoxCameraScreen.getCurrentIncrement()));
            editBox.method_1852(String.valueOf(OrthoViewHandler.roundValue(((Float)supplier.get()).floatValue())));
        }).setDrawBackground().setTextureLayout(SpritelessImageButton.SINGLE_TEXTURE_LAYOUT);
        TooltipBuilder.create().setLines(EditBoxCameraScreen.getCurrentTooltipLines('-')).build((class_339)minusButton);
        widgets.add((class_339)minusButton);
        widgets.add(this.getResetButton(rowHeight, () -> {
            consumer.accept(Float.valueOf(component.getDefaultValue()));
            editBox.method_1852(String.valueOf(OrthoViewHandler.roundValue(component.getDefaultValue())));
        }));
    }

    private static int getMaxComponentWidth(class_327 font) {
        return Math.max(font.method_27525((class_5348)COMPONENT_Y_ROT), Math.max(font.method_27525((class_5348)COMPONENT_ZOOM), font.method_27525((class_5348)COMPONENT_X_ROT)));
    }
}

