/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pixelshot.client.gui.screens;

import fuzs.pixelshot.client.gui.screens.AbstractCameraScreen;
import fuzs.pixelshot.client.handler.OrthoViewHandler;
import fuzs.puzzleslib.api.client.gui.v2.components.RangedSliderButton;
import fuzs.puzzleslib.api.client.gui.v2.components.SpritelessImageButton;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_7919;

public class SliderCameraScreen
extends AbstractCameraScreen {
    public SliderCameraScreen(class_2561 title, OrthoViewHandler handler) {
        super(AbstractCameraScreen.Type.SLIDER, title, handler);
    }

    @Override
    void addControlRow(final AbstractCameraScreen.OrthoComponent component, int rowHeight, Collection<class_339> widgets) {
        super.addControlRow(component, rowHeight, widgets);
        final Consumer<Float> consumer = value -> component.consumer.accept(this.handler, (Float)value);
        Supplier<Float> supplier = () -> component.supplier.apply(this.handler);
        RangedSliderButton sliderButton = new RangedSliderButton(this.field_22789 / 2 - 130, rowHeight, 260, 20, supplier.get().floatValue(), component.minValue, component.maxValue){
            static final double LOGARITHMIC_SCALE = 4.0;
            static final double LOGARITHMIC_SCALE_POW = Math.pow(10.0, -4.0);

            public double getScaledValue() {
                if (component.supportsLogarithmicScale()) {
                    double value = Math.pow(10.0, this.getValue() * 4.0 - 4.0) - LOGARITHMIC_SCALE_POW;
                    return value * (this.maxValue - this.minValue) + this.minValue;
                }
                return super.getScaledValue();
            }

            public void setScaledValue(double value) {
                if (component.supportsLogarithmicScale()) {
                    value = (value - this.minValue) / (this.maxValue - this.minValue);
                    this.method_25347((Math.log10(value + LOGARITHMIC_SCALE_POW) + 4.0) / 4.0);
                } else {
                    super.setScaledValue(value);
                }
            }

            protected class_2561 getMessageFromValue(double value) {
                return class_2561.method_43469((String)component.translationKey, (Object[])new Object[]{Float.valueOf(OrthoViewHandler.roundValue((float)value))});
            }

            protected void applyValue(double value) {
                consumer.accept(Float.valueOf((float)value));
            }
        };
        widgets.add((class_339)sliderButton);
        SpritelessImageButton plusButton = new SpritelessImageButton(this.field_22789 / 2 + 134, rowHeight, 20, 20, 60, 0, WIDGETS_LOCATION, button -> {
            consumer.accept(Float.valueOf(((Float)supplier.get()).floatValue() + SliderCameraScreen.getCurrentIncrement()));
            sliderButton.setScaledValue((double)((Float)supplier.get()).floatValue());
        }).setDrawBackground().setTextureLayout(SpritelessImageButton.SINGLE_TEXTURE_LAYOUT);
        plusButton.method_47400((class_7919)new AbstractCameraScreen.DynamicTooltip((class_339)plusButton, '+'));
        widgets.add((class_339)plusButton);
        SpritelessImageButton minusButton = new SpritelessImageButton(this.field_22789 / 2 - 154, rowHeight, 20, 20, 40, 0, WIDGETS_LOCATION, button -> {
            consumer.accept(Float.valueOf(((Float)supplier.get()).floatValue() - SliderCameraScreen.getCurrentIncrement()));
            sliderButton.setScaledValue((double)((Float)supplier.get()).floatValue());
        }).setDrawBackground().setTextureLayout(SpritelessImageButton.SINGLE_TEXTURE_LAYOUT);
        minusButton.method_47400((class_7919)new AbstractCameraScreen.DynamicTooltip((class_339)minusButton, '-'));
        widgets.add((class_339)minusButton);
        widgets.add(this.getResetButton(rowHeight, () -> {
            consumer.accept(Float.valueOf(component.getDefaultValue()));
            sliderButton.setScaledValue((double)component.getDefaultValue());
        }));
    }
}

