/*
 * Decompiled with CFR 0.152.
 */
package com.moigferdsrte.sandwichable.blocks.entity;

import com.moigferdsrte.sandwichable.blocks.extra.PickleJarFluid;
import com.moigferdsrte.sandwichable.blocks.extra.SyncedBlockEntity;
import com.moigferdsrte.sandwichable.common.CommonTags;
import com.moigferdsrte.sandwichable.config.SandwichableConfig;
import com.moigferdsrte.sandwichable.registry.BlocksRegistry;
import com.moigferdsrte.sandwichable.registry.ItemsRegistry;
import com.moigferdsrte.sandwichable.util.Util;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class PickleJarBlockEntity
extends class_2586
implements class_1278,
SyncedBlockEntity {
    private PickleJarFluid fluid = PickleJarFluid.AIR;
    private int numItems = 0;
    private boolean areItemsPickled = false;
    private int pickleProgress = 0;
    public static final int pickleTime = 1200;
    private static final int maxItems = 4;

    public PickleJarBlockEntity(class_2338 pos, class_2680 state) {
        super(BlocksRegistry.PICKLEJAR_BLOCKENTITY, pos, state);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.fluid = PickleJarFluid.fromString(nbt.method_10558("pickleJarFluid"));
        this.numItems = nbt.method_10550("numItems");
        this.areItemsPickled = nbt.method_10577("areItemsPickled");
        this.pickleProgress = nbt.method_10550("pickleProgress");
    }

    public void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10582("pickleJarFluid", this.fluid.toString());
        nbt.method_10569("numItems", this.numItems);
        nbt.method_10556("areItemsPickled", this.areItemsPickled);
        nbt.method_10569("pickleProgress", this.pickleProgress);
        nbt.method_10582("id", "Contents");
    }

    public class_1269 onUse(class_1937 world, class_1657 player, class_1268 hand, class_2338 pos) {
        class_1799 playerStack = player.method_5998(hand);
        class_1792 playerItem = playerStack.method_7909();
        if (playerStack.method_31573(CommonTags.CUCUMBER) && this.fluid == PickleJarFluid.WATER && this.numItems < 4) {
            if (!player.method_7337()) {
                playerStack.method_7934(1);
            }
            if (this.numItems == 0) {
                this.areItemsPickled = false;
            }
            ++this.numItems;
            this.update();
            return class_1269.field_5812;
        }
        if (playerStack.method_31573(CommonTags.PICKLED_CUCUMBER) && this.fluid == PickleJarFluid.PICKLED_BRINE && this.numItems < 4) {
            if (!player.method_7337()) {
                playerStack.method_7934(1);
            }
            if (this.numItems == 0) {
                this.areItemsPickled = true;
            }
            ++this.numItems;
            this.update();
            return class_1269.field_5812;
        }
        if (playerItem == class_1802.field_8705 && this.fluid == PickleJarFluid.AIR) {
            if (!player.method_7337()) {
                player.method_6122(hand, new class_1799((class_1935)class_1802.field_8550, 1));
            }
            this.fillWater(true);
            return class_1269.field_5812;
        }
        if (playerItem == ItemsRegistry.PICKLE_BRINE_BUCKET && this.fluid == PickleJarFluid.AIR) {
            if (!player.method_7337()) {
                player.method_6122(hand, new class_1799((class_1935)class_1802.field_8550, 1));
            }
            this.fillBrine(true);
            return class_1269.field_5812;
        }
        if (playerItem == class_1802.field_8550 && (this.fluid == PickleJarFluid.WATER || this.fluid == PickleJarFluid.PICKLED_BRINE)) {
            if (!player.method_7337()) {
                playerStack.method_7934(1);
                player.method_7270(new class_1799((class_1935)(this.fluid == PickleJarFluid.WATER ? class_1802.field_8705 : ItemsRegistry.PICKLE_BRINE_BUCKET), 1));
            }
            this.emptyFluid(true);
            return class_1269.field_5812;
        }
        if (playerStack.method_31573(CommonTags.SALT) && this.fluid == PickleJarFluid.WATER && this.numItems > 0) {
            if (!player.method_7337()) {
                playerStack.method_7934(1);
            }
            this.startPickling();
            this.update();
            return class_1269.field_5812;
        }
        SandwichableConfig config = Util.getConfig();
        if (this.fluid == PickleJarFluid.WATER && !this.areItemsPickled && this.numItems > 0) {
            --this.numItems;
            class_1542 item = new class_1542(world, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, config.itemOptions.cucumberItemGetter.get().method_7972());
            item.method_6988();
            world.method_8649((class_1297)item);
            this.update();
            return class_1269.field_5812;
        }
        if (this.fluid == PickleJarFluid.PICKLED_BRINE && this.areItemsPickled && this.numItems > 0) {
            --this.numItems;
            class_1542 item = new class_1542(world, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.05, (double)pos.method_10260() + 0.5, config.itemOptions.pickledCucumberItemGetter.get().method_7972());
            item.method_6988();
            world.method_8649((class_1297)item);
            if (this.numItems == 0) {
                this.fluid = PickleJarFluid.AIR;
                this.areItemsPickled = false;
            }
            this.update();
            return class_1269.field_5812;
        }
        this.update();
        return class_1269.field_5811;
    }

    public PickleJarFluid getFluid() {
        return this.fluid;
    }

    public int getItemCount() {
        return this.numItems;
    }

    public boolean areItemsPickled() {
        return this.areItemsPickled;
    }

    public int getPickleProgress() {
        return this.pickleProgress;
    }

    public void startPickling() {
        this.fluid = PickleJarFluid.PICKLING_BRINE;
        this.field_11863.method_8396(null, this.field_11867, class_3417.field_14978, class_3419.field_15245, 0.8f, 1.67f);
    }

    @Nullable
    public class_1799 emptyFluid(boolean withBucket) {
        if (this.getFluid() == PickleJarFluid.WATER || this.getFluid() == PickleJarFluid.PICKLED_BRINE) {
            for (int i = 0; i < this.numItems; ++i) {
                class_1799 stack = this.areItemsPickled ? new class_1799((class_1935)ItemsRegistry.PICKLED_CUCUMBER) : new class_1799((class_1935)ItemsRegistry.CUCUMBER);
                class_1542 item = new class_1542(this.field_11863, (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5, stack);
                this.field_11863.method_8649((class_1297)item);
            }
            this.fluid = PickleJarFluid.AIR;
            this.numItems = 0;
            if (withBucket) {
                this.field_11863.method_8396(null, this.field_11867, class_3417.field_15126, class_3419.field_15245, 0.8f, 1.0f);
            }
            this.update();
            return new class_1799((class_1935)(this.getFluid() == PickleJarFluid.WATER ? class_1802.field_8705 : ItemsRegistry.PICKLE_BRINE_BUCKET));
        }
        this.update();
        return null;
    }

    public void fillWater(boolean withBucket) {
        if (this.getFluid() == PickleJarFluid.AIR) {
            if (withBucket) {
                this.field_11863.method_8396(null, this.field_11867, class_3417.field_14834, class_3419.field_15245, 0.8f, 1.0f);
            }
            this.fluid = PickleJarFluid.WATER;
            this.update();
        }
    }

    public void fillBrine(boolean withBucket) {
        if (this.getFluid() == PickleJarFluid.AIR) {
            if (withBucket) {
                this.field_11863.method_8396(null, this.field_11867, class_3417.field_14834, class_3419.field_15245, 0.8f, 1.0f);
            }
            this.fluid = PickleJarFluid.PICKLED_BRINE;
            this.areItemsPickled = true;
            this.pickleProgress = 0;
            this.update();
        }
    }

    private void finishPickling() {
        this.fluid = PickleJarFluid.PICKLED_BRINE;
        this.pickleProgress = 0;
        this.areItemsPickled = true;
        this.method_5431();
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, PickleJarBlockEntity self) {
        if (self.fluid == PickleJarFluid.PICKLING_BRINE && self.pickleProgress < 1200) {
            ++self.pickleProgress;
        } else if (self.pickleProgress == 1200) {
            self.finishPickling();
        }
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        class_2487 nbt = new class_2487();
        this.method_11007(nbt, registryLookup);
        return nbt;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return this.getPacket();
    }

    public void update() {
        this.field_11863.method_8455(this.field_11867, this.field_11863.method_8320(this.field_11867).method_26204());
        Util.sync(this);
        this.method_5431();
    }

    public int[] method_5494(class_2350 side) {
        return new int[]{0, 1, 2, 3};
    }

    public boolean method_5492(int slot, class_1799 stack, class_2350 dir) {
        return ++slot > this.numItems && this.isInsertable(stack);
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return this.numItems > 0;
    }

    public int method_5439() {
        return 4;
    }

    public boolean method_5442() {
        return this.numItems <= 0;
    }

    public class_1799 method_5438(int slot) {
        class_1799 stack;
        class_1799 class_17992 = this.getFluid() == PickleJarFluid.WATER && !this.areItemsPickled ? new class_1799((class_1935)ItemsRegistry.CUCUMBER) : (stack = this.getFluid() == PickleJarFluid.PICKLED_BRINE && this.areItemsPickled ? new class_1799((class_1935)ItemsRegistry.PICKLED_CUCUMBER) : class_1799.field_8037);
        return this.numItems > 0 ? (++slot <= this.numItems ? stack : class_1799.field_8037) : class_1799.field_8037;
    }

    public class_1799 method_5434(int slot, int amount) {
        class_1799 stack = this.method_5438(slot);
        if (this.numItems > 0) {
            --this.numItems;
        }
        if (this.numItems == 0 && this.getFluid() == PickleJarFluid.PICKLED_BRINE) {
            this.fluid = PickleJarFluid.AIR;
        }
        this.update();
        return stack;
    }

    public class_1799 method_5441(int slot) {
        return this.method_5434(slot, 1);
    }

    public void method_5447(int slot, class_1799 stack) {
        if (this.isInsertable(stack)) {
            ++this.numItems;
        }
        this.update();
    }

    public boolean method_5443(class_1657 player) {
        return false;
    }

    public void method_5448() {
        this.numItems = 0;
        this.update();
    }

    private boolean isInsertable(class_1799 stack) {
        if (this.numItems < 4) {
            return stack.method_7909() == ItemsRegistry.CUCUMBER && this.fluid == PickleJarFluid.WATER && !this.areItemsPickled || stack.method_7909() == ItemsRegistry.PICKLED_CUCUMBER && this.fluid == PickleJarFluid.PICKLED_BRINE && this.areItemsPickled;
        }
        return false;
    }
}

