/*
 * Decompiled with CFR 0.152.
 */
package com.moigferdsrte.sandwichable.config;

import com.google.common.base.Suppliers;
import com.moigferdsrte.sandwichable.config.ConfigInABarrel;
import com.moigferdsrte.sandwichable.registry.ItemsRegistry;
import com.moigferdsrte.sandwichable.util.Util;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_437;
import net.minecraft.class_7923;

public class SandwichableConfig
extends ConfigInABarrel {
    public boolean showInfoTooltips = true;
    public TooltipKeyBind infoTooltipKeyBind = TooltipKeyBind.SHIFT;
    public boolean slowEatingLargeSandwiches = true;
    public int baseSandwichEatTime = 32;
    @ConfigInABarrel.Value(gui=false)
    public ItemOptions itemOptions = new ItemOptions();
    public SaltySandGenOptions saltySandGenOptions = new SaltySandGenOptions();
    public ShrubGenOptions shrubGenOptions = new ShrubGenOptions();
    public SaltPoolGenOptions saltPoolGenOptions = new SaltPoolGenOptions();

    public static KitchenKnifeOption[] knivesDefault() {
        return new KitchenKnifeOption[]{new KitchenKnifeOption("sandwichable:stone_kitchen_knife", 1, 132), new KitchenKnifeOption("sandwichable:kitchen_knife", 3, 850), new KitchenKnifeOption("sandwichable:golden_kitchen_knife", 5, 225), new KitchenKnifeOption("sandwichable:diamond_kitchen_knife", 8, 1025), new KitchenKnifeOption("sandwichable:netherite_kitchen_knife", 20, 1984), new KitchenKnifeOption("sandwichable:glass_kitchen_knife", 1, 0)};
    }

    public KitchenKnifeOption getKnifeOption(String knife) {
        for (KitchenKnifeOption opt : this.itemOptions.knives) {
            if (!knife.equals(opt.itemId)) continue;
            return opt;
        }
        return null;
    }

    public KitchenKnifeOption getKnifeOption(class_1792 knife) {
        return this.getKnifeOption(class_7923.field_41178.method_10221((Object)knife).toString());
    }

    @Override
    public void afterLoad() {
        KitchenKnifeOption[] defaults;
        super.afterLoad();
        for (KitchenKnifeOption def : defaults = SandwichableConfig.knivesDefault()) {
            KitchenKnifeOption opt = this.getKnifeOption(def.itemId);
            if (opt == null || opt.sharpness != 0) continue;
            opt.sharpness = def.sharpness;
        }
    }

    public static enum TooltipKeyBind {
        SHIFT("shift"),
        CTRL("control"),
        ALT("alt");

        final String name;

        private TooltipKeyBind(String name) {
            this.name = name;
        }

        public boolean isPressed() {
            if (this.equals((Object)SHIFT)) {
                return class_437.method_25442();
            }
            if (this.equals((Object)CTRL)) {
                return class_437.method_25441();
            }
            if (this.equals((Object)ALT)) {
                return class_437.method_25443();
            }
            return false;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class ItemOptions {
        public KitchenKnifeOption[] knives = SandwichableConfig.knivesDefault();
        @ConfigInABarrel.Value(gui=false)
        public String saltItem = "sandwichable:salt";
        @ConfigInABarrel.Value(gui=false)
        public String cucumberItem = "sandwichable:cucumber";
        @ConfigInABarrel.Value(gui=false)
        public String pickledCucumberItem = "sandwichable:pickled_cucumber";
        @ConfigInABarrel.Value(gui=false)
        public String burntFoodItem = "sandwichable:burnt_food";
        @ConfigInABarrel.Value(gui=false)
        public String burntMorselItem = "sandwichable:burnt_morsel";
        @ConfigInABarrel.Value(gui=false)
        public final transient Supplier<class_1799> saltItemGetter = Suppliers.memoize(() -> Util.itemFromString(this.saltItem, () -> new class_1799((class_1935)ItemsRegistry.SALT)));
        @ConfigInABarrel.Value(gui=false)
        public final transient Supplier<class_1799> cucumberItemGetter = Suppliers.memoize(() -> Util.itemFromString(this.cucumberItem, () -> new class_1799((class_1935)ItemsRegistry.CUCUMBER)));
        @ConfigInABarrel.Value(gui=false)
        public final transient Supplier<class_1799> pickledCucumberItemGetter = Suppliers.memoize(() -> Util.itemFromString(this.pickledCucumberItem, () -> new class_1799((class_1935)ItemsRegistry.PICKLED_CUCUMBER)));
        @ConfigInABarrel.Value(gui=false)
        public final transient Supplier<class_1799> burntFoodItemGetter = Suppliers.memoize(() -> Util.itemFromString(this.burntFoodItem, () -> new class_1799((class_1935)ItemsRegistry.BURNT_FOOD)));
        @ConfigInABarrel.Value(gui=false)
        public final transient Supplier<class_1799> burntMorselItemGetter = Suppliers.memoize(() -> Util.itemFromString(this.burntMorselItem, () -> new class_1799((class_1935)ItemsRegistry.BURNT_MORSEL)));
    }

    public static class SaltySandGenOptions {
        public boolean saltySand = true;
    }

    public static class ShrubGenOptions {
        public int spawnTries = 10;
    }

    public static class SaltPoolGenOptions {
        public boolean saltPools = true;
        public boolean drySaltPools = true;
    }

    public static class KitchenKnifeOption {
        public String itemId;
        public int value;
        public int sharpness;

        public KitchenKnifeOption(String item, int value, int sharpness) {
            this.itemId = item;
            this.value = value;
            this.sharpness = sharpness;
        }
    }
}

