/*
 * Decompiled with CFR 0.152.
 */
package com.moigferdsrte.sandwichable.util;

import com.google.common.collect.Maps;
import com.moigferdsrte.sandwichable.Sandwichable;
import com.moigferdsrte.sandwichable.items.spread.FermentingMilkSpreadType;
import com.moigferdsrte.sandwichable.items.spread.HoneySpreadType;
import com.moigferdsrte.sandwichable.items.spread.PotionSpreadType;
import com.moigferdsrte.sandwichable.items.spread.SpreadType;
import com.moigferdsrte.sandwichable.items.spread.SuspiciousStewSpreadType;
import com.moigferdsrte.sandwichable.registry.ItemsRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;

public class SpreadRegistry {
    public static final SpreadRegistry INSTANCE = new SpreadRegistry();
    private final Map<String, SpreadType> idToSpreadType = Maps.newHashMap();
    private final Map<SpreadType, String> spreadTypeToString = Maps.newHashMap();
    private final Map<class_1935, SpreadType> spreadContainerToType = new HashMap<class_1935, SpreadType>();
    public static final SpreadType MUSHROOM_STEW = new SpreadType(6, 0.6f, 11367505, (class_1935)class_1802.field_8208, (class_1935)class_1802.field_8428);
    public static final SpreadType RABBIT_STEW = new SpreadType(10, 0.6f, 12546612, (class_1935)class_1802.field_8308, (class_1935)class_1802.field_8428);
    public static final SpreadType BEETROOT_SOUP = new SpreadType(6, 0.6f, 9175075, (class_1935)class_1802.field_8515, (class_1935)class_1802.field_8428);
    public static final HoneySpreadType HONEY = new HoneySpreadType();
    public static final SuspiciousStewSpreadType SUSPICIOUS_STEW = new SuspiciousStewSpreadType();
    public static final FermentingMilkSpreadType FERMENTING_MILK = new FermentingMilkSpreadType();
    public static final PotionSpreadType POTION = new PotionSpreadType();
    public static final SpreadType SWEET_BERRY_JAM = new SpreadType(5, 0.5f, 15728676, (class_1935)ItemsRegistry.SWEET_BERRY_JAM, (class_1935)class_1802.field_8469);
    public static final SpreadType GLOW_BERRY_JAM = new SpreadType(5, 0.5f, 16763732, (class_1935)ItemsRegistry.GLOW_BERRY_JAM, (class_1935)class_1802.field_8469);
    public static final SpreadType MAYONNAISE = new SpreadType(4, 0.6f, 16766389, (class_1935)ItemsRegistry.MAYONNAISE, (class_1935)class_1802.field_8469);

    private SpreadRegistry() {
    }

    public static void init() {
        INSTANCE.register("mushroom_stew", MUSHROOM_STEW);
        INSTANCE.register("rabbit_stew", RABBIT_STEW);
        INSTANCE.register("beetroot_soup", BEETROOT_SOUP);
        INSTANCE.register("honey", HONEY);
        INSTANCE.register("suspicious_stew", SUSPICIOUS_STEW);
        INSTANCE.register("fermenting_milk", FERMENTING_MILK);
        INSTANCE.register("sweet_berry_jam", SWEET_BERRY_JAM);
        INSTANCE.register("glow_berry_jam", GLOW_BERRY_JAM);
        INSTANCE.register("mayonnaise", MAYONNAISE);
        INSTANCE.register("potion", POTION);
    }

    public SpreadType register(String id, SpreadType type) {
        this.idToSpreadType.put(id, type);
        this.spreadTypeToString.put(type, id);
        this.spreadContainerToType.put(type.getContainingItem(), type);
        return type;
    }

    public SpreadType getSpreadFromItem(class_1935 item) {
        return this.spreadContainerToType.get(item);
    }

    public boolean itemHasSpread(class_1935 item) {
        return this.spreadContainerToType.containsKey(item);
    }

    public class_1792 getItem(SpreadType type) {
        if (type == BEETROOT_SOUP) {
            return ItemsRegistry.BEETROOT_SOUP_SPREAD;
        }
        if (type == RABBIT_STEW) {
            return ItemsRegistry.RABBIT_STEW_SPREAD;
        }
        if (type == MUSHROOM_STEW) {
            return ItemsRegistry.MUSHROOM_STEW_SPREAD;
        }
        if (type == HONEY) {
            return ItemsRegistry.HONEY_SPREAD;
        }
        if (type == SUSPICIOUS_STEW) {
            return ItemsRegistry.SUSPICIOUS_STEW_SPREAD;
        }
        if (type == FERMENTING_MILK) {
            return ItemsRegistry.FERMENTING_MILK_SPREAD;
        }
        if (type == POTION) {
            return ItemsRegistry.POTION_SPREAD;
        }
        if (type == SWEET_BERRY_JAM) {
            return ItemsRegistry.SWEET_BERRY_JAM_SPREAD;
        }
        if (type == GLOW_BERRY_JAM) {
            return ItemsRegistry.GLOW_BERRY_JAM_SPREAD;
        }
        if (type == MAYONNAISE) {
            return ItemsRegistry.MAYONNAISE_SPREAD;
        }
        return class_1799.field_8037.method_7909();
    }

    public SpreadType fromString(String id) {
        if (id == null) {
            Sandwichable.LOGGER.warn("NULL SpreadType ID");
            return null;
        }
        return this.idToSpreadType.get(id);
    }

    public String asString(SpreadType type) {
        return this.spreadTypeToString.get(type);
    }
}

