/*
 * Decompiled with CFR 0.152.
 */
package io.github.maplemods.sapling.networking.packets;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import io.github.maplemods.sapling.data.ClientVariables;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import org.jetbrains.annotations.NotNull;

public class ToClientSendEntityTextureDataPacket {
    public static final Identifier CHANNEL = Identifier.fromNamespaceAndPath((String)"sapling", (String)"to_client_send_entity_texture_data_packet");
    public static final StreamCodec<FriendlyByteBuf, ToClientSendEntityTextureDataPacket> STREAM_CODEC = StreamCodec.ofMember(ToClientSendEntityTextureDataPacket::encode, ToClientSendEntityTextureDataPacket::new);
    private final UUID entityUUID;
    private final Identifier textureIdentifier;

    public ToClientSendEntityTextureDataPacket(FriendlyByteBuf buf) {
        this.entityUUID = buf.readUUID();
        this.textureIdentifier = buf.readIdentifier();
    }

    public ToClientSendEntityTextureDataPacket(UUID entityUUID, Identifier textureIdentifier) {
        this.entityUUID = entityUUID;
        this.textureIdentifier = textureIdentifier;
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
    CustomPacketPayload.Type<@NotNull CustomPacketPayload> type() {
        return new CustomPacketPayload.Type(CHANNEL);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeUUID(this.entityUUID);
        buf.writeIdentifier(this.textureIdentifier);
    }

    public static void handle(PacketContext<ToClientSendEntityTextureDataPacket> ctx) {
        if (ctx.side().equals((Object)Side.CLIENT)) {
            ToClientSendEntityTextureDataPacket packet = (ToClientSendEntityTextureDataPacket)ctx.message();
            UUID entityUUID = packet.entityUUID;
            Identifier textureIdentifier = packet.textureIdentifier;
            if (entityUUID == null || textureIdentifier == null) {
                return;
            }
            ClientVariables.cachedTextures.put(entityUUID, textureIdentifier);
        }
    }
}

