/*
 * Decompiled with CFR 0.152.
 */
package io.github.maplemods.sapling.mixin;

import io.github.maplemods.sapling.data.Textures;
import io.github.maplemods.sapling.functions.RandomFunctions;
import io.github.maplemods.sapling.functions.TextureFunctions;
import io.github.maplemods.sapling.render.BeeRenderStateExt;
import java.util.UUID;
import net.minecraft.client.renderer.entity.BeeRenderer;
import net.minecraft.client.renderer.entity.state.BeeRenderState;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.animal.bee.Bee;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BeeRenderer.class})
public class BeeRendererMixin {
    @Inject(method={"extractRenderState(Lnet/minecraft/world/entity/animal/bee/Bee;Lnet/minecraft/client/renderer/entity/state/BeeRenderState;F)V"}, at={@At(value="TAIL")})
    private void sapling$attachBee(Bee bee, BeeRenderState state, float partialTicks, CallbackInfo ci) {
        ((BeeRenderStateExt)state).sapling$setBee(bee);
    }

    @Inject(method={"getTextureLocation(Lnet/minecraft/client/renderer/entity/state/BeeRenderState;)Lnet/minecraft/resources/Identifier;"}, at={@At(value="HEAD")}, cancellable=true)
    public void getTextureLocation(BeeRenderState beeRenderState, CallbackInfoReturnable<Identifier> cir) {
        if (Textures.beeTexturePairs.isEmpty()) {
            return;
        }
        Bee bee = ((BeeRenderStateExt)beeRenderState).sapling$getBee();
        if (bee == null) {
            return;
        }
        UUID beeUUID = bee.getUUID();
        Identifier baseIdentifier = TextureFunctions.getCachedEntityTexture(beeUUID);
        if (baseIdentifier == null && (baseIdentifier = RandomFunctions.getRandomBeeTexture(Textures.beeTexturePairs)) == null) {
            return;
        }
        Identifier beeIdentifier = bee.isAngry() ? (bee.hasNectar() ? this.angryNectarIdentifier(baseIdentifier) : this.angryIdentifier(baseIdentifier)) : (bee.hasNectar() ? this.nectarIdentifier(baseIdentifier) : baseIdentifier);
        cir.setReturnValue((Object)beeIdentifier);
    }

    @Unique
    private Identifier nectarIdentifier(Identifier baseIdentifier) {
        return Identifier.fromNamespaceAndPath((String)baseIdentifier.getNamespace(), (String)baseIdentifier.getPath().replace(".png", "_nectar.png"));
    }

    @Unique
    private Identifier angryIdentifier(Identifier baseIdentifier) {
        return Identifier.fromNamespaceAndPath((String)baseIdentifier.getNamespace(), (String)baseIdentifier.getPath().replace(".png", "_angry.png"));
    }

    @Unique
    private Identifier angryNectarIdentifier(Identifier baseIdentifier) {
        return Identifier.fromNamespaceAndPath((String)baseIdentifier.getNamespace(), (String)baseIdentifier.getPath().replace(".png", "_angry_nectar.png"));
    }
}

