/*
 * Decompiled with CFR 0.152.
 */
package io.github.maplemods.sapling.mixin;

import io.github.maplemods.sapling.data.Textures;
import io.github.maplemods.sapling.functions.RandomFunctions;
import io.github.maplemods.sapling.functions.TextureFunctions;
import java.util.UUID;
import net.minecraft.client.renderer.entity.BeeRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.Bee;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BeeRenderer.class})
public class BeeRendererMixin {
    @Inject(method={"getTextureLocation(Lnet/minecraft/world/entity/animal/Bee;)Lnet/minecraft/resources/ResourceLocation;"}, at={@At(value="HEAD")}, cancellable=true)
    public void getTextureLocation(Bee bee, CallbackInfoReturnable<ResourceLocation> cir) {
        if (Textures.beeTexturePairs.isEmpty()) {
            return;
        }
        UUID beeUUID = bee.getUUID();
        ResourceLocation baseResourceLocation = TextureFunctions.getCachedEntityTexture(beeUUID);
        if (baseResourceLocation == null && (baseResourceLocation = RandomFunctions.getRandomBeeTexture(Textures.beeTexturePairs)) == null) {
            return;
        }
        ResourceLocation beeResourceLocation = bee.isAngry() ? (bee.hasNectar() ? this.angryNectarResourceLocation(baseResourceLocation) : this.angryResourceLocation(baseResourceLocation)) : (bee.hasNectar() ? this.nectarResourceLocation(baseResourceLocation) : baseResourceLocation);
        cir.setReturnValue((Object)beeResourceLocation);
    }

    @Unique
    private ResourceLocation nectarResourceLocation(ResourceLocation baseResourceLocation) {
        return ResourceLocation.fromNamespaceAndPath((String)baseResourceLocation.getNamespace(), (String)baseResourceLocation.getPath().replace(".png", "_nectar.png"));
    }

    @Unique
    private ResourceLocation angryResourceLocation(ResourceLocation baseResourceLocation) {
        return ResourceLocation.fromNamespaceAndPath((String)baseResourceLocation.getNamespace(), (String)baseResourceLocation.getPath().replace(".png", "_angry.png"));
    }

    @Unique
    private ResourceLocation angryNectarResourceLocation(ResourceLocation baseResourceLocation) {
        return ResourceLocation.fromNamespaceAndPath((String)baseResourceLocation.getNamespace(), (String)baseResourceLocation.getPath().replace(".png", "_angry_nectar.png"));
    }
}

