/*
 * Decompiled with CFR 0.152.
 */
package io.github.maplemods.sapling.networking.packets;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import io.github.maplemods.sapling.data.ClientVariables;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class ToClientSendEntityTextureDataPacket {
    public static final ResourceLocation CHANNEL = new ResourceLocation("sapling", "to_client_send_entity_texture_data_packet");
    private final UUID entityUUID;
    private final ResourceLocation textureResourceLocation;

    public static ToClientSendEntityTextureDataPacket decode(FriendlyByteBuf buf) {
        UUID entityUUIDIn = buf.m_130259_();
        ResourceLocation textureResourceLocationIn = buf.m_130281_();
        return new ToClientSendEntityTextureDataPacket(entityUUIDIn, textureResourceLocationIn);
    }

    public ToClientSendEntityTextureDataPacket(UUID entityUUID, ResourceLocation textureResourceLocation) {
        this.entityUUID = entityUUID;
        this.textureResourceLocation = textureResourceLocation;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.entityUUID);
        buf.m_130085_(this.textureResourceLocation);
    }

    public static void handle(PacketContext<ToClientSendEntityTextureDataPacket> ctx) {
        if (ctx.side().equals((Object)Side.CLIENT)) {
            ToClientSendEntityTextureDataPacket packet = (ToClientSendEntityTextureDataPacket)ctx.message();
            UUID entityUUID = packet.entityUUID;
            ResourceLocation textureResourceLocation = packet.textureResourceLocation;
            if (entityUUID == null || textureResourceLocation == null) {
                return;
            }
            ClientVariables.cachedTextures.put(entityUUID, textureResourceLocation);
        }
    }
}

