/*
 * Decompiled with CFR 0.152.
 */
package io.github.maplemods.sapling.networking.packets;

import commonnetwork.api.Dispatcher;
import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import io.github.maplemods.sapling.functions.TagFunctions;
import io.github.maplemods.sapling.networking.packets.ToClientSendEntityTextureDataPacket;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class ToServerRequestEntityTextureDataPacket {
    public static final ResourceLocation CHANNEL = new ResourceLocation("sapling", "to_server_request_entity_texture_data_packet");
    private final UUID entityUUID;

    public static ToServerRequestEntityTextureDataPacket decode(FriendlyByteBuf buf) {
        UUID entityUUIDin = buf.m_130259_();
        return new ToServerRequestEntityTextureDataPacket(entityUUIDin);
    }

    public ToServerRequestEntityTextureDataPacket(UUID entityUUIDIn) {
        this.entityUUID = entityUUIDIn;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.entityUUID);
    }

    public static void handle(PacketContext<ToServerRequestEntityTextureDataPacket> ctx) {
        if (ctx.side().equals((Object)Side.SERVER)) {
            ToServerRequestEntityTextureDataPacket packet = (ToServerRequestEntityTextureDataPacket)ctx.message();
            UUID uuid = packet.entityUUID;
            if (uuid == null) {
                return;
            }
            ServerPlayer serverPlayer = ctx.sender();
            ServerLevel serverLevel = serverPlayer.m_284548_();
            Entity entity = serverLevel.m_8791_(uuid);
            if (entity == null) {
                return;
            }
            ResourceLocation textureResourceLocation = TagFunctions.getCustomEntityTextureIfExists(entity);
            if (textureResourceLocation == null) {
                return;
            }
            Dispatcher.sendToClient((Object)new ToClientSendEntityTextureDataPacket(uuid, textureResourceLocation), (ServerPlayer)serverPlayer);
        }
    }
}

