/*
 * Decompiled with CFR 0.152.
 */
package io.github.maplemods.sapling.networking.packets;

import commonnetwork.api.Dispatcher;
import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import io.github.maplemods.sapling.functions.TagFunctions;
import io.github.maplemods.sapling.networking.packets.ToClientSendEntityTextureDataPacket;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class ToServerRequestEntityTextureDataPacket {
    public static final class_2960 CHANNEL = new class_2960("sapling", "to_server_request_entity_texture_data_packet");
    private final UUID entityUUID;

    public static ToServerRequestEntityTextureDataPacket decode(class_2540 buf) {
        UUID entityUUIDin = buf.method_10790();
        return new ToServerRequestEntityTextureDataPacket(entityUUIDin);
    }

    public ToServerRequestEntityTextureDataPacket(UUID entityUUIDIn) {
        this.entityUUID = entityUUIDIn;
    }

    public void encode(class_2540 buf) {
        buf.method_10797(this.entityUUID);
    }

    public static void handle(PacketContext<ToServerRequestEntityTextureDataPacket> ctx) {
        if (ctx.side().equals((Object)Side.SERVER)) {
            ToServerRequestEntityTextureDataPacket packet = (ToServerRequestEntityTextureDataPacket)ctx.message();
            UUID uuid = packet.entityUUID;
            if (uuid == null) {
                return;
            }
            class_3222 serverPlayer = ctx.sender();
            class_3218 serverLevel = serverPlayer.method_51469();
            class_1297 entity = serverLevel.method_14190(uuid);
            if (entity == null) {
                return;
            }
            class_2960 textureResourceLocation = TagFunctions.getCustomEntityTextureIfExists(entity);
            if (textureResourceLocation == null) {
                return;
            }
            Dispatcher.sendToClient((Object)new ToClientSendEntityTextureDataPacket(uuid, textureResourceLocation), (class_3222)serverPlayer);
        }
    }
}

