/*
 * Decompiled with CFR 0.152.
 */
package de.mcjunky33.armor_hud.client;

import de.mcjunky33.armor_hud.client.config.ArmorHudConfig;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class ArmorHudOverlay {
    private final ArmorHudConfig config = ArmorHudConfig.getInstance();
    private static final class_2960 HOTBAR_TEXTURE = class_2960.method_60655((String)"armor_hud", (String)"textures/gui/hotbar_texture.png");
    private static final class_2960 HOTBAR_TEXTURE_DARK = class_2960.method_60655((String)"armor_hud", (String)"textures/gui/hotbar_texture_dark.png");
    private static final int[] ARMOR_ORDER = new int[]{39, 38, 37, 36};

    public void renderArmorUI(class_332 context) {
        class_310 client = class_310.method_1551();
        if (!this.config.isVisible() || client.field_1690.field_1842 || client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        class_1799[] armorItems = new class_1799[4];
        for (int i = 0; i < 4; ++i) {
            armorItems[i] = client.field_1724.method_31548().method_5438(ARMOR_ORDER[i]);
        }
        int screenWidth = client.method_22683().method_4486();
        int screenHeight = client.method_22683().method_4502();
        this.renderInternal(context, screenWidth / 2, screenHeight, armorItems, this.config);
        if (!this.config.isShowHandDurability()) {
            return;
        }
        class_1799 mainHand = client.field_1724.method_6047();
        class_1799 offHand = client.field_1724.method_6079();
        int hotbarStartX = screenWidth / 2 - 91;
        int hotbarY = screenHeight - 22;
        int selectedSlot = client.field_1724.method_31548().method_67532();
        int mainSlotX = hotbarStartX + selectedSlot * 20;
        int mainSlotCenterX = mainSlotX + 12;
        int offhandSlotX = hotbarStartX - 20;
        int offhandSlotCenterX = offhandSlotX + 2;
        int barWidth = 16;
        int barY = hotbarY + 14;
        int textY = hotbarY - 6;
        boolean showBar = this.config.isShowDurabilityBar();
        int durabilityMode = this.config.getDurabilityDisplayMode();
        if (!mainHand.method_7960() && mainHand.method_7936() > 0 && durabilityMode != 0) {
            this.drawDurabilityTextSimple(context, mainSlotCenterX - barWidth / 2, textY, barWidth, mainHand, 0, 0, durabilityMode == 2);
        }
        if (!offHand.method_7960() && offHand.method_7936() > 0 && durabilityMode != 0) {
            this.drawDurabilityTextSimple(context, offhandSlotCenterX - barWidth / 2, textY, barWidth, offHand, 0, 0, durabilityMode == 2);
        }
    }

    public static void renderPreview(class_332 context, int screenWidth, int screenHeight, ArmorHudConfig config) {
        class_1799[] previewArmor = new class_1799[]{new class_1799((class_1935)class_1802.field_8805), new class_1799((class_1935)class_1802.field_8678), new class_1799((class_1935)class_1802.field_8570), new class_1799((class_1935)class_1802.field_8313)};
        for (int i = 0; i < previewArmor.length; ++i) {
            class_1799 item = previewArmor[i];
            int max = item.method_7936();
            item.method_7974(switch (i) {
                case 0 -> max * 9 / 10;
                case 1 -> max / 4;
                case 2 -> max * 3 / 4;
                case 3 -> max / 2;
                default -> 0;
            });
        }
        new ArmorHudOverlay().renderInternal(context, screenWidth / 2, screenHeight, previewArmor, config);
    }

    private void renderInternal(class_332 context, int baseX, int baseY, class_1799[] armorItems, ArmorHudConfig config) {
        int boxSize = config.getBoxSize();
        int spacing = config.getSpacing();
        if (config.isVertical()) {
            if (config.isSplitMode()) {
                int i;
                for (i = 0; i < 2; ++i) {
                    this.drawBoxAndArmor(context, armorItems[i], baseX + config.getXOffsetLeft2(), baseY + config.getYOffsetLeft2(), boxSize, spacing, i, true, config.getNumberOffsetXLeft(), config.getNumberOffsetYLeft());
                }
                for (i = 2; i < 4; ++i) {
                    this.drawBoxAndArmor(context, armorItems[i], baseX + config.getXOffsetRight(), baseY + config.getYOffsetRight(), boxSize, spacing, i - 2, true, config.getNumberOffsetXRight(), config.getNumberOffsetYRight());
                }
            } else {
                for (int i = 0; i < 4; ++i) {
                    this.drawBoxAndArmor(context, armorItems[i], baseX + config.getXOffsetLeftVertical(), baseY + config.getYOffsetLeftVertical(), boxSize, spacing, i, true, config.getNumberOffsetXLeftVertical(), config.getNumberOffsetYLeftVertical());
                }
            }
        } else if (config.isSplitMode()) {
            int i;
            for (i = 0; i < 2; ++i) {
                this.drawBoxAndArmor(context, armorItems[i], baseX + config.getXOffsetLeft2(), baseY + config.getYOffsetLeft2(), boxSize, spacing, i, false, config.getNumberOffsetXLeft(), config.getNumberOffsetYLeft());
            }
            for (i = 2; i < 4; ++i) {
                this.drawBoxAndArmor(context, armorItems[i], baseX + config.getXOffsetRight(), baseY + config.getYOffsetRight(), boxSize, spacing, i - 2, false, config.getNumberOffsetXRight(), config.getNumberOffsetYRight());
            }
        } else {
            for (int i = 0; i < 4; ++i) {
                this.drawBoxAndArmor(context, armorItems[i], baseX + config.getXOffset(), baseY + config.getYOffset(), boxSize, spacing, i, false, config.getNumberOffsetX(), config.getNumberOffsetY());
            }
        }
    }

    private void drawBoxAndArmor(class_332 context, class_1799 armorItem, int baseX, int baseY, int boxSize, int spacing, int idx, boolean vertical, int offsetXNumber, int offsetYNumber) {
        if (armorItem.method_7960()) {
            return;
        }
        int boxX = baseX + (!vertical ? idx * (boxSize + spacing) : 0);
        int boxY = baseY + (vertical ? idx * (boxSize + spacing) : 0);
        if (this.config.isShowBoxTexture()) {
            class_2960 texture = this.config.isDarkMode() ? HOTBAR_TEXTURE_DARK : HOTBAR_TEXTURE;
            context.method_25290(class_10799.field_56883, texture, boxX, boxY, 0.0f, 0.0f, boxSize, boxSize, boxSize, boxSize);
        }
        int itemX = boxX + (boxSize - 16) / 2;
        int itemY = boxY + (boxSize - 16) / 2;
        context.method_51427(armorItem, itemX, itemY);
        int mode = this.config.getDurabilityDisplayMode();
        if (this.config.isShowDurabilityBar()) {
            this.drawDurabilityBar(context, boxX, boxY + boxSize - 6, boxSize, armorItem);
        }
        if (mode == 1) {
            this.drawDurabilityTextSimple(context, boxX, boxY, boxSize, armorItem, offsetXNumber, offsetYNumber, false);
        } else if (mode == 2) {
            this.drawDurabilityTextSimple(context, boxX, boxY, boxSize, armorItem, offsetXNumber, offsetYNumber, true);
        }
    }

    public void drawDurabilityBar(class_332 context, int x, int y, int width, class_1799 item) {
        int maxDamage = item.method_7936();
        if (maxDamage <= 0) {
            return;
        }
        int damage = item.method_7919();
        if (damage <= 0) {
            return;
        }
        float ratio = (float)(maxDamage - damage) / (float)maxDamage;
        int barWidth = 13;
        int barX = x + (width - barWidth) / 2 + 1;
        this.fill(context, barX, y, barX + barWidth, y + 2, -16777216);
        this.fill(context, barX, y, barX + Math.round(ratio * (float)barWidth), y + 1, this.convertHSVtoARGB(ratio / 3.0f * 360.0f, 1.0f, 1.0f));
    }

    public void drawDurabilityTextSimple(class_332 context, int boxX, int boxY, int boxSize, class_1799 item, int offsetX, int offsetY, boolean showPercent) {
        String text;
        int maxDamage = item.method_7936();
        if (maxDamage <= 0) {
            return;
        }
        int durability = maxDamage - item.method_7919();
        float ratio = (float)durability / (float)maxDamage;
        String string = text = showPercent ? Math.round(ratio * 100.0f) + "%" : String.valueOf(durability);
        int color = ratio > 0.7f ? -16711936 : (ratio > 0.4f ? -256 : (ratio > 0.2f ? -23296 : (ratio > 0.05f ? -65536 : -16777216)));
        class_327 tr = class_310.method_1551().field_1772;
        int textX = boxX + (boxSize - tr.method_1727(text)) / 2 + offsetX;
        Objects.requireNonNull(tr);
        int textY = boxY + boxSize - 9 + offsetY;
        context.method_25303(tr, text, textX, textY, color);
    }

    private void fill(class_332 context, int x1, int y1, int x2, int y2, int color) {
        context.method_25294(x1, y1, x2, y2, color);
    }

    private int convertHSVtoARGB(float h, float s, float v) {
        h = (h % 360.0f + 360.0f) % 360.0f;
        float hh = h / 60.0f;
        int i = (int)hh;
        float f = hh - (float)i;
        float p = v * (1.0f - s);
        float q = v * (1.0f - f * s);
        float t = v * (1.0f - (1.0f - f) * s);
        float r = switch (i) {
            case 0 -> v;
            case 1 -> q;
            case 2 -> p;
            case 3 -> p;
            case 4 -> t;
            default -> v;
        };
        float g = switch (i) {
            case 0 -> t;
            case 1 -> v;
            case 2 -> v;
            case 3 -> q;
            case 4 -> p;
            default -> p;
        };
        float b = switch (i) {
            case 0 -> p;
            case 1 -> p;
            case 2 -> t;
            case 3 -> v;
            case 4 -> v;
            default -> q;
        };
        return 0xFF000000 | (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f);
    }
}

