/*
 * Decompiled with CFR 0.152.
 */
package de.mcjunky33.armor_hud.client.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class ArmorHudConfig {
    private static volatile ArmorHudConfig INSTANCE;
    private static final Gson GSON;
    private static final Path CONFIG_PATH;
    public static final int DEFAULT_X_OFFSET_NORM_HOR = -220;
    public static final int DEFAULT_Y_OFFSET_NORM_HOR = -22;
    public static final int DEFAULT_X_OFFSET_LEFT2_HOR = -180;
    public static final int DEFAULT_Y_OFFSET_LEFT2_HOR = -22;
    public static final int DEFAULT_X_OFFSET_RIGHT_HOR = 100;
    public static final int DEFAULT_Y_OFFSET_RIGHT_HOR = -22;
    public static final int DEFAULT_X_OFFSET_LEFT_VERTICAL_1 = -950;
    public static final int DEFAULT_Y_OFFSET_LEFT_VERTICAL_1 = -112;
    public static final int DEFAULT_X_OFFSET_LEFT_VERTICAL_2 = -470;
    public static final int DEFAULT_Y_OFFSET_LEFT_VERTICAL_2 = -102;
    public static final int DEFAULT_X_OFFSET_LEFT_VERTICAL_3 = -310;
    public static final int DEFAULT_Y_OFFSET_LEFT_VERTICAL_3 = -102;
    public static final int DEFAULT_X_OFFSET_LEFT_VERTICAL_4 = -230;
    public static final int DEFAULT_Y_OFFSET_LEFT_VERTICAL_4 = -102;
    public static final int DEFAULT_X_OFFSET_LEFT2_1 = -950;
    public static final int DEFAULT_Y_OFFSET_LEFT2_1 = -52;
    public static final int DEFAULT_X_OFFSET_RIGHT_1 = 930;
    public static final int DEFAULT_Y_OFFSET_RIGHT_1 = -52;
    public static final int DEFAULT_X_OFFSET_LEFT2_2 = -470;
    public static final int DEFAULT_Y_OFFSET_LEFT2_2 = -52;
    public static final int DEFAULT_X_OFFSET_RIGHT_2 = 450;
    public static final int DEFAULT_Y_OFFSET_RIGHT_2 = -52;
    public static final int DEFAULT_X_OFFSET_LEFT2_3 = -310;
    public static final int DEFAULT_Y_OFFSET_LEFT2_3 = -52;
    public static final int DEFAULT_X_OFFSET_RIGHT_3 = 290;
    public static final int DEFAULT_Y_OFFSET_RIGHT_3 = -52;
    public static final int DEFAULT_X_OFFSET_LEFT2_4 = -230;
    public static final int DEFAULT_Y_OFFSET_LEFT2_4 = -52;
    public static final int DEFAULT_X_OFFSET_RIGHT_4 = -210;
    public static final int DEFAULT_Y_OFFSET_RIGHT_4 = -52;
    public static final int DEFAULT_BOX_SIZE = 22;
    public static final int DEFAULT_SPACING = 2;
    private int xOffset;
    private int yOffset;
    private int xOffsetLeft1;
    private int yOffsetLeft1;
    private int xOffsetLeft2;
    private int yOffsetLeft2;
    private int xOffsetRight;
    private int yOffsetRight;
    private boolean splitMode = false;
    private boolean vertical = false;
    private float durabilityWarningThreshold;
    private int boxSize;
    private int spacing;
    private boolean visible;
    private int durabilityDisplayMode = 0;
    private boolean darkMode;
    private boolean showBoxTexture = true;
    private String language = "auto";
    private int lastGuiScaleChecked = -1;
    private int numberOffsetX = 0;
    private int numberOffsetY = -12;
    private int numberOffsetXLeft = 0;
    private int numberOffsetYLeft = -12;
    private int numberOffsetXRight = 0;
    private int numberOffsetYRight = -12;
    private int xOffsetLeftVertical = -950;
    private int yOffsetLeftVertical = -112;
    private int numberOffsetXLeftVertical = 0;
    private int numberOffsetYLeftVertical = 0;
    private boolean showDurabilityBar = true;
    private boolean showDurabilityText = true;
    private boolean showDurabilityPercent = false;
    private boolean showHandDurability = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ArmorHudConfig getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<ArmorHudConfig> clazz = ArmorHudConfig.class;
        synchronized (ArmorHudConfig.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = ArmorHudConfig.loadOrCreate();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private static ArmorHudConfig loadOrCreate() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                String json = Files.readString(CONFIG_PATH);
                return (ArmorHudConfig)GSON.fromJson(json, ArmorHudConfig.class);
            }
            catch (IOException e) {
                System.err.println("Failed to load config: " + e.getMessage());
            }
        }
        return ArmorHudConfig.createDefaultConfig();
    }

    private static ArmorHudConfig createDefaultConfig() {
        ArmorHudConfig config = new ArmorHudConfig();
        config.boxSize = 22;
        config.spacing = 2;
        config.durabilityWarningThreshold = 0.2f;
        config.visible = true;
        config.durabilityDisplayMode = 0;
        config.darkMode = false;
        config.showBoxTexture = true;
        config.language = "auto";
        config.splitMode = false;
        config.vertical = false;
        config.xOffset = -220;
        config.yOffset = -22;
        config.xOffsetLeft1 = -950;
        config.yOffsetLeft1 = -112;
        config.xOffsetLeft2 = -950;
        config.yOffsetLeft2 = -52;
        config.xOffsetRight = 930;
        config.yOffsetRight = -52;
        config.xOffsetLeftVertical = -950;
        config.yOffsetLeftVertical = -112;
        config.numberOffsetXLeftVertical = 0;
        config.numberOffsetYLeftVertical = 0;
        config.lastGuiScaleChecked = -1;
        config.showHandDurability = false;
        config.showDurabilityBar = true;
        config.showDurabilityText = true;
        config.showDurabilityPercent = false;
        config.saveConfig();
        return config;
    }

    public void saveConfig() {
        try {
            if (!Files.exists(CONFIG_PATH.getParent(), new LinkOption[0])) {
                Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            }
            String json = GSON.toJson((Object)this);
            Files.writeString(CONFIG_PATH, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            System.err.println("Failed to save config: " + e.getMessage());
        }
    }

    public void resetToDefaults() {
        this.visible = true;
        this.language = "en";
        this.durabilityDisplayMode = 0;
        this.darkMode = false;
        this.showBoxTexture = true;
        this.vertical = false;
        this.splitMode = false;
        this.boxSize = 22;
        this.spacing = 2;
        this.durabilityWarningThreshold = 0.2f;
        this.numberOffsetX = 0;
        this.numberOffsetY = -12;
        this.numberOffsetXLeft = 0;
        this.numberOffsetYLeft = -12;
        this.numberOffsetXRight = 0;
        this.numberOffsetYRight = -12;
        this.xOffset = -220;
        this.yOffset = -22;
        this.xOffsetLeft1 = -950;
        this.yOffsetLeft1 = -112;
        this.xOffsetLeft2 = -950;
        this.yOffsetLeft2 = -52;
        this.xOffsetRight = 930;
        this.yOffsetRight = -52;
        this.xOffsetLeftVertical = -950;
        this.yOffsetLeftVertical = -112;
        this.numberOffsetXLeftVertical = 0;
        this.numberOffsetYLeftVertical = -12;
        this.lastGuiScaleChecked = -1;
        this.showHandDurability = false;
        this.showDurabilityBar = true;
        this.showDurabilityText = true;
        this.showDurabilityPercent = false;
        this.applyCurrentModeDefaults();
        this.saveConfig();
    }

    public int getCurrentGuiScale() {
        try {
            return (Integer)class_310.method_1551().field_1690.method_42474().method_41753();
        }
        catch (Exception e) {
            return 2;
        }
    }

    public boolean isShowDurabilityBar() {
        return this.showDurabilityBar;
    }

    public void setShowDurabilityBar(boolean value) {
        this.showDurabilityBar = value;
        this.saveConfig();
    }

    public boolean isShowDurabilityText() {
        return this.showDurabilityText;
    }

    public void setShowDurabilityText(boolean value) {
        this.showDurabilityText = value;
        this.saveConfig();
    }

    public boolean isShowDurabilityPercent() {
        return this.showDurabilityPercent;
    }

    public void setShowDurabilityPercent(boolean value) {
        this.showDurabilityPercent = value;
        this.saveConfig();
    }

    public boolean isShowHandDurability() {
        return this.showHandDurability;
    }

    public void setShowHandDurability(boolean show) {
        this.showHandDurability = show;
        this.saveConfig();
    }

    public int getLastGuiScaleChecked() {
        return this.lastGuiScaleChecked;
    }

    public void setLastGuiScaleChecked(int value) {
        this.lastGuiScaleChecked = value;
        this.saveConfig();
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public void setXOffset(int xOffset) {
        this.xOffset = xOffset;
        this.saveConfig();
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public void setYOffset(int yOffset) {
        this.yOffset = yOffset;
        this.saveConfig();
    }

    public int getXOffsetLeft1() {
        return this.xOffsetLeft1;
    }

    public void setXOffsetLeft1(int xOffsetLeft1) {
        this.xOffsetLeft1 = xOffsetLeft1;
        this.saveConfig();
    }

    public int getYOffsetLeft1() {
        return this.yOffsetLeft1;
    }

    public void setYOffsetLeft1(int yOffsetLeft1) {
        this.yOffsetLeft1 = yOffsetLeft1;
        this.saveConfig();
    }

    public int getXOffsetLeft2() {
        return this.xOffsetLeft2;
    }

    public void setXOffsetLeft2(int xOffsetLeft2) {
        this.xOffsetLeft2 = xOffsetLeft2;
        this.saveConfig();
    }

    public int getYOffsetLeft2() {
        return this.yOffsetLeft2;
    }

    public void setYOffsetLeft2(int yOffsetLeft2) {
        this.yOffsetLeft2 = yOffsetLeft2;
        this.saveConfig();
    }

    public int getXOffsetRight() {
        return this.xOffsetRight;
    }

    public void setXOffsetRight(int xOffsetRight) {
        this.xOffsetRight = xOffsetRight;
        this.saveConfig();
    }

    public int getYOffsetRight() {
        return this.yOffsetRight;
    }

    public void setYOffsetRight(int yOffsetRight) {
        this.yOffsetRight = yOffsetRight;
        this.saveConfig();
    }

    public int getXOffsetLeftVertical() {
        return this.xOffsetLeftVertical;
    }

    public void setXOffsetLeftVertical(int value) {
        this.xOffsetLeftVertical = value;
        this.saveConfig();
    }

    public int getYOffsetLeftVertical() {
        return this.yOffsetLeftVertical;
    }

    public void setYOffsetLeftVertical(int value) {
        this.yOffsetLeftVertical = value;
        this.saveConfig();
    }

    public int getNumberOffsetXLeftVertical() {
        return this.numberOffsetXLeftVertical;
    }

    public void setNumberOffsetXLeftVertical(int value) {
        this.numberOffsetXLeftVertical = value;
        this.saveConfig();
    }

    public int getNumberOffsetYLeftVertical() {
        return this.numberOffsetYLeftVertical;
    }

    public void setNumberOffsetYLeftVertical(int value) {
        this.numberOffsetYLeftVertical = value;
        this.saveConfig();
    }

    public int getNumberOffsetX() {
        return this.numberOffsetX;
    }

    public void setNumberOffsetX(int numberOffsetX) {
        this.numberOffsetX = numberOffsetX;
        this.saveConfig();
    }

    public int getNumberOffsetY() {
        return this.numberOffsetY;
    }

    public void setNumberOffsetY(int numberOffsetY) {
        this.numberOffsetY = numberOffsetY;
        this.saveConfig();
    }

    public int getNumberOffsetXLeft() {
        return this.numberOffsetXLeft;
    }

    public void setNumberOffsetXLeft(int numberOffsetXLeft) {
        this.numberOffsetXLeft = numberOffsetXLeft;
        this.saveConfig();
    }

    public int getNumberOffsetYLeft() {
        return this.numberOffsetYLeft;
    }

    public void setNumberOffsetYLeft(int numberOffsetYLeft) {
        this.numberOffsetYLeft = numberOffsetYLeft;
        this.saveConfig();
    }

    public int getNumberOffsetXRight() {
        return this.numberOffsetXRight;
    }

    public void setNumberOffsetXRight(int numberOffsetXRight) {
        this.numberOffsetXRight = numberOffsetXRight;
        this.saveConfig();
    }

    public int getNumberOffsetYRight() {
        return this.numberOffsetYRight;
    }

    public void setNumberOffsetYRight(int numberOffsetYRight) {
        this.numberOffsetYRight = numberOffsetYRight;
        this.saveConfig();
    }

    public boolean isSplitMode() {
        return this.splitMode;
    }

    public void setSplitMode(boolean splitMode) {
        this.splitMode = splitMode;
        this.applyCurrentModeDefaults();
        this.saveConfig();
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setVertical(boolean vertical) {
        this.vertical = vertical;
        this.applyCurrentModeDefaults();
        this.saveConfig();
    }

    public float getDurabilityWarningThreshold() {
        return this.durabilityWarningThreshold;
    }

    public void setDurabilityWarningThreshold(float durabilityWarningThreshold) {
        this.durabilityWarningThreshold = durabilityWarningThreshold;
        this.saveConfig();
    }

    public int getBoxSize() {
        return this.boxSize;
    }

    public void setBoxSize(int boxSize) {
        this.boxSize = boxSize;
        this.saveConfig();
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
        this.saveConfig();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.saveConfig();
    }

    public boolean isShowBoxTexture() {
        return this.showBoxTexture;
    }

    public void setShowBoxTexture(boolean showBoxTexture) {
        this.showBoxTexture = showBoxTexture;
        this.saveConfig();
    }

    public int getDurabilityDisplayMode() {
        return this.durabilityDisplayMode;
    }

    public void setDurabilityDisplayMode(int durabilityDisplayMode) {
        this.durabilityDisplayMode = durabilityDisplayMode;
        this.saveConfig();
    }

    public boolean isDarkMode() {
        return this.darkMode && this.showBoxTexture;
    }

    public void setDarkMode(boolean darkMode) {
        this.darkMode = darkMode;
        this.saveConfig();
    }

    public String getLanguage() {
        return this.language == null ? "auto" : this.language;
    }

    public void setLanguage(String language) {
        this.language = language == null ? "auto" : language;
        this.saveConfig();
    }

    public void applyCurrentModeDefaults() {
        int guiScale = this.getCurrentGuiScale();
        if (guiScale > 4) {
            guiScale = 4;
        }
        if (this.vertical && !this.splitMode) {
            switch (guiScale) {
                case 1: {
                    this.xOffsetLeftVertical = -950;
                    this.yOffsetLeftVertical = -112;
                    break;
                }
                case 2: {
                    this.xOffsetLeftVertical = -470;
                    this.yOffsetLeftVertical = -102;
                    break;
                }
                case 3: {
                    this.xOffsetLeftVertical = -310;
                    this.yOffsetLeftVertical = -102;
                    break;
                }
                case 4: {
                    this.xOffsetLeftVertical = -230;
                    this.yOffsetLeftVertical = -102;
                }
            }
        } else if (this.vertical && this.splitMode) {
            switch (guiScale) {
                case 1: {
                    this.xOffsetLeft2 = -950;
                    this.yOffsetLeft2 = -52;
                    this.xOffsetRight = 930;
                    this.yOffsetRight = -52;
                    break;
                }
                case 2: {
                    this.xOffsetLeft2 = -470;
                    this.yOffsetLeft2 = -52;
                    this.xOffsetRight = 450;
                    this.yOffsetRight = -52;
                    break;
                }
                case 3: {
                    this.xOffsetLeft2 = -310;
                    this.yOffsetLeft2 = -52;
                    this.xOffsetRight = 290;
                    this.yOffsetRight = -52;
                    break;
                }
                case 4: {
                    this.xOffsetLeft2 = -230;
                    this.yOffsetLeft2 = -52;
                    this.xOffsetRight = -210;
                    this.yOffsetRight = -52;
                }
            }
        } else if (this.splitMode) {
            this.xOffsetLeft2 = -180;
            this.yOffsetLeft2 = -22;
            this.xOffsetRight = 100;
            this.yOffsetRight = -22;
        } else {
            this.xOffset = -220;
            this.yOffset = -22;
        }
        this.saveConfig();
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().create();
        CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("armor_hud.json");
    }
}

