/*
 * Decompiled with CFR 0.152.
 */
package de.mcjunky33.armor_hud.client.config;

import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import de.mcjunky33.armor_hud.client.ArmorHudOverlay;
import de.mcjunky33.armor_hud.client.config.ArmorHudConfig;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class ModMenuIntegration
implements ModMenuApi {
    public ConfigScreenFactory<?> getModConfigScreenFactory() {
        return parent -> new SimpleConfigScreen(parent);
    }

    @Environment(value=EnvType.CLIENT)
    public static class SimpleConfigScreen
    extends class_437 {
        private final class_437 parent;
        private final ArmorHudConfig config;
        private static final Set<String> GERMAN_LANGS = Set.of("de_de", "de_at", "de_ch", "de_li", "de_lu", "de");
        private String currentLanguage;
        private class_342 boxSizeField;
        private class_342 spacingField;
        private class_342 xOffsetLeft2Field;
        private class_342 yOffsetLeft2Field;
        private class_342 numberOffsetXLeftField;
        private class_342 numberOffsetYLeftField;
        private class_342 xOffsetRightField;
        private class_342 yOffsetRightField;
        private class_342 numberOffsetXRightField;
        private class_342 numberOffsetYRightField;
        private class_342 xOffsetField;
        private class_342 yOffsetField;
        private class_342 numberOffsetXField;
        private class_342 numberOffsetYField;
        private transient class_342 xOffsetVerticalField;
        private transient class_342 yOffsetVerticalField;
        private transient class_342 numberOffsetXVerticalField;
        private transient class_342 numberOffsetYVerticalField;

        public SimpleConfigScreen(class_437 parent) {
            super((class_2561)class_2561.method_43470((String)"Armor HUD Configuration"));
            this.parent = parent;
            this.config = ArmorHudConfig.getInstance();
            this.currentLanguage = this.detectLanguage();
        }

        private String detectLanguage() {
            String configLang = this.config.getLanguage();
            if (!"auto".equals(configLang)) {
                return configLang;
            }
            String mcLang = class_310.method_1551().field_1690.field_1883;
            if (mcLang == null) {
                mcLang = "en_us";
            }
            return GERMAN_LANGS.contains(mcLang = mcLang.toLowerCase()) ? "de" : "en";
        }

        private String tr(String key) {
            if ("de".equals(this.currentLanguage)) {
                return switch (key) {
                    case "title" -> "Armor HUD Konfiguration";
                    case "hud_visible" -> "HUD Sichtbar";
                    case "durability_number" -> "Zahl";
                    case "durability_off" -> "Aus";
                    case "durability_percent" -> "Prozent";
                    case "durability_mode" -> "Durability Nummern";
                    case "durability_bar_on" -> "Durability Bar: An";
                    case "durability_bar_off" -> "Durability Bar: Aus";
                    case "darkmode" -> "Darkmode";
                    case "orientation" -> "Ausrichtung";
                    case "vertical" -> "Vertikal (untereinander)";
                    case "horizontal" -> "Horizontal (nebeneinander)";
                    case "splitmode_on" -> "Split-Modus: An";
                    case "splitmode_off" -> "Split-Modus: Aus";
                    case "box_size" -> "Box-Gr\u00f6\u00dfe";
                    case "box_size_minus" -> "Box -2";
                    case "box_size_plus" -> "Box +2";
                    case "spacing" -> "Abstand";
                    case "spacing_minus" -> "Abstand -1";
                    case "spacing_plus" -> "Abstand +1";
                    case "defaults" -> "Standardwerte";
                    case "done" -> "Fertig";
                    case "offset_hint" -> "X = nach rechts, Y = nach unten";
                    case "lang_button_de" -> "Sprache: Deutsch";
                    case "lang_button_en" -> "Language: English";
                    case "left2_coords" -> "Helm+Brust";
                    case "right_coords" -> "Hose+Schuhe";
                    case "number_offset_left" -> "Nummern Helm+Brust";
                    case "number_offset_right" -> "Nummern Hose+Schuhe";
                    case "show_box_texture_on" -> "Box-Textur: An";
                    case "show_box_texture_off" -> "Box-Textur: Aus";
                    case "hand_durability_on" -> "Zeige Hand Item Durability: An";
                    case "hand_durability_off" -> "Zeige Hand Item Durability: Aus";
                    default -> key;
                };
            }
            return switch (key) {
                case "title" -> "Armor HUD Configuration";
                case "hud_visible" -> "HUD Visible";
                case "durability_number" -> "Number";
                case "durability_off" -> "Off";
                case "durability_percent" -> "Percent";
                case "durability_mode" -> "Durability Numbers";
                case "durability_bar_on" -> "Durability Bar: On";
                case "durability_bar_off" -> "Durability Bar: Off";
                case "darkmode" -> "Darkmode";
                case "orientation" -> "Orientation";
                case "vertical" -> "Vertical (stacked)";
                case "horizontal" -> "Horizontal (side by side)";
                case "splitmode_on" -> "Split Mode: On";
                case "splitmode_off" -> "Split Mode: Off";
                case "box_size" -> "Box Size";
                case "box_size_minus" -> "Box -2";
                case "box_size_plus" -> "Box +2";
                case "spacing" -> "Spacing";
                case "spacing_minus" -> "Spacing -1";
                case "spacing_plus" -> "Spacing +1";
                case "defaults" -> "Defaults";
                case "done" -> "Done";
                case "offset_hint" -> "X = move right, Y = move down";
                case "lang_button_de" -> "Sprache: Deutsch";
                case "lang_button_en" -> "Language: English";
                case "left2_coords" -> "Helmet+Chestplate";
                case "right_coords" -> "Leggings+Boots";
                case "number_offset_left" -> "Numbers Helmet+Chestplate";
                case "number_offset_right" -> "Numbers Leggings+Boots";
                case "show_box_texture_on" -> "Box Texture: On";
                case "show_box_texture_off" -> "Box Texture: Off";
                case "hand_durability_on" -> "Show Hand Item Durability: On";
                case "hand_durability_off" -> "Show Hand Item Durability: Off";
                default -> key;
            };
        }

        protected void method_25426() {
            this.method_37067();
            int winW = this.field_22789;
            int winH = this.field_22790;
            int btnW = Math.max(90, Math.min(140, winW / 7));
            int btnH = Math.max(18, Math.min(24, winH / 32));
            int smallBtnW = Math.max(40, btnW / 2);
            int fieldW = Math.max(40, Math.min(58, winW / 14));
            int arrowBtn = Math.max(22, btnH);
            int marginY = Math.max(6, btnH / 2);
            int marginX = Math.max(8, winW / 64);
            int langBtnW = Math.max(110, btnW);
            int langBtnX = winW - langBtnW - marginX;
            int langBtnY = marginY;
            String langBtnText = "de".equals(this.currentLanguage) ? this.tr("lang_button_de") : this.tr("lang_button_en");
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)langBtnText), btn -> {
                this.config.setLanguage("de".equals(this.currentLanguage) ? "en" : "de");
                this.field_22787.method_1507((class_437)new SimpleConfigScreen(this.parent));
            }).method_46434(langBtnX, langBtnY, langBtnW, btnH).method_46431());
            int toggleStartX = langBtnX;
            int toggleY = langBtnY + btnH + marginY * 4;
            int toggleStepY = btnH + 2;
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.tr("hud_visible") + ": " + (this.config.isVisible() ? ("de".equals(this.currentLanguage) ? "An" : "On") : ("de".equals(this.currentLanguage) ? "Aus" : "Off")))), btn -> {
                this.config.setVisible(!this.config.isVisible());
                btn.method_25355((class_2561)class_2561.method_43470((String)(this.tr("hud_visible") + ": " + (this.config.isVisible() ? ("de".equals(this.currentLanguage) ? "An" : "On") : ("de".equals(this.currentLanguage) ? "Aus" : "Off")))));
                this.field_22787.method_1507((class_437)new SimpleConfigScreen(this.parent));
            }).method_46434(toggleStartX, toggleY, btnW, btnH).method_46431());
            String[] durabilityModes = new String[]{this.tr("durability_off"), this.tr("durability_number"), this.tr("durability_percent")};
            int mode = this.config.getDurabilityDisplayMode();
            class_4185 durabilityModeButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.tr("durability_mode") + ": " + durabilityModes[mode])), btn -> {
                int newMode = (this.config.getDurabilityDisplayMode() + 1) % 3;
                this.config.setDurabilityDisplayMode(newMode);
                btn.method_25355((class_2561)class_2561.method_43470((String)(this.tr("durability_mode") + ": " + durabilityModes[newMode])));
            }).method_46434(toggleStartX, toggleY += toggleStepY, btnW, btnH).method_46431();
            this.method_37063((class_364)durabilityModeButton);
            class_4185 durabilityBarButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.config.isShowDurabilityBar() ? this.tr("durability_bar_on") : this.tr("durability_bar_off"))), btn -> {
                boolean newState = !this.config.isShowDurabilityBar();
                this.config.setShowDurabilityBar(newState);
                btn.method_25355((class_2561)class_2561.method_43470((String)(newState ? this.tr("durability_bar_on") : this.tr("durability_bar_off"))));
            }).method_46434(toggleStartX, toggleY += toggleStepY, btnW, btnH).method_46431();
            this.method_37063((class_364)durabilityBarButton);
            String showBoxTextMsg = this.config.isShowBoxTexture() ? this.tr("show_box_texture_on") : this.tr("show_box_texture_off");
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)showBoxTextMsg), btn -> {
                this.config.setShowBoxTexture(!this.config.isShowBoxTexture());
                btn.method_25355((class_2561)class_2561.method_43470((String)(this.config.isShowBoxTexture() ? this.tr("show_box_texture_on") : this.tr("show_box_texture_off"))));
                this.field_22787.method_1507((class_437)new SimpleConfigScreen(this.parent));
            }).method_46434(toggleStartX, toggleY += toggleStepY, btnW, btnH).method_46431());
            toggleY += toggleStepY;
            if (this.config.isShowBoxTexture()) {
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.tr("darkmode") + ": " + (this.config.isDarkMode() ? ("de".equals(this.currentLanguage) ? "An" : "On") : ("de".equals(this.currentLanguage) ? "Aus" : "Off")))), btn -> {
                    this.config.setDarkMode(!this.config.isDarkMode());
                    btn.method_25355((class_2561)class_2561.method_43470((String)(this.tr("darkmode") + ": " + (this.config.isDarkMode() ? ("de".equals(this.currentLanguage) ? "An" : "On") : ("de".equals(this.currentLanguage) ? "Aus" : "Off")))));
                }).method_46434(toggleStartX, toggleY, btnW, btnH).method_46431());
                toggleY += toggleStepY;
            }
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.tr("orientation") + ": " + (this.config.isVertical() ? this.tr("vertical") : this.tr("horizontal")))), btn -> {
                boolean newVertical = !this.config.isVertical();
                this.config.setVertical(newVertical);
                btn.method_25355((class_2561)class_2561.method_43470((String)(this.tr("orientation") + ": " + (newVertical ? this.tr("vertical") : this.tr("horizontal")))));
                this.method_25396().removeIf(child -> child instanceof class_342 || child instanceof class_4185 && ((class_4185)child).method_25369().getString().isEmpty());
                this.method_25426();
            }).method_46434(toggleStartX, toggleY, btnW, btnH).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.config.isSplitMode() ? this.tr("splitmode_on") : this.tr("splitmode_off"))), btn -> {
                this.config.setSplitMode(!this.config.isSplitMode());
                btn.method_25355((class_2561)class_2561.method_43470((String)(this.config.isSplitMode() ? this.tr("splitmode_on") : this.tr("splitmode_off"))));
                this.field_22787.method_1507((class_437)new SimpleConfigScreen(this.parent));
            }).method_46434(toggleStartX, toggleY += toggleStepY, btnW, btnH).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.config.isShowHandDurability() ? this.tr("hand_durability_on") : this.tr("hand_durability_off"))), btn -> {
                boolean newState = !this.config.isShowHandDurability();
                this.config.setShowHandDurability(newState);
                btn.method_25355((class_2561)class_2561.method_43470((String)(newState ? this.tr("hand_durability_on") : this.tr("hand_durability_off"))));
            }).method_46434(toggleStartX, toggleY += toggleStepY, btnW, btnH).method_46431());
            int adjustStartY = langBtnY;
            int adjustX = marginX;
            int adjustStepY = btnH + 8;
            int boxY = adjustStartY;
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)this.tr("box_size_minus")), btn -> {
                this.config.setBoxSize(Math.max(16, this.config.getBoxSize() - 2));
                this.boxSizeField.method_1852(String.valueOf(this.config.getBoxSize()));
            }).method_46434(adjustX, boxY, smallBtnW, btnH).method_46431());
            this.boxSizeField = new class_342(this.field_22793, adjustX + smallBtnW + 4, boxY, fieldW, btnH, (class_2561)class_2561.method_43470((String)""));
            this.boxSizeField.method_1852(String.valueOf(this.config.getBoxSize()));
            this.boxSizeField.method_1863(txt -> {
                try {
                    this.config.setBoxSize(Math.max(16, Integer.parseInt(txt)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
            this.method_37063((class_364)this.boxSizeField);
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)this.tr("box_size_plus")), btn -> {
                this.config.setBoxSize(this.config.getBoxSize() + 2);
                this.boxSizeField.method_1852(String.valueOf(this.config.getBoxSize()));
            }).method_46434(adjustX + smallBtnW + 4 + fieldW + 4, boxY, smallBtnW, btnH).method_46431());
            int spacingY = boxY + adjustStepY;
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)this.tr("spacing_minus")), btn -> {
                this.config.setSpacing(Math.max(0, this.config.getSpacing() - 1));
                this.spacingField.method_1852(String.valueOf(this.config.getSpacing()));
            }).method_46434(adjustX, spacingY, smallBtnW, btnH).method_46431());
            this.spacingField = new class_342(this.field_22793, adjustX + smallBtnW + 4, spacingY, fieldW, btnH, (class_2561)class_2561.method_43470((String)""));
            this.spacingField.method_1852(String.valueOf(this.config.getSpacing()));
            this.spacingField.method_1863(txt -> {
                try {
                    this.config.setSpacing(Math.max(0, Integer.parseInt(txt)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
            this.method_37063((class_364)this.spacingField);
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)this.tr("spacing_plus")), btn -> {
                this.config.setSpacing(this.config.getSpacing() + 1);
                this.spacingField.method_1852(String.valueOf(this.config.getSpacing()));
            }).method_46434(adjustX + smallBtnW + 4 + fieldW + 4, spacingY, smallBtnW, btnH).method_46431());
            int coordY = spacingY + adjustStepY + 4;
            int rightFieldStartX = adjustX + arrowBtn + 4 + fieldW + 4 + arrowBtn + marginX;
            if (this.config.isSplitMode()) {
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2190"), btn -> {
                    this.config.setXOffsetLeft2(this.config.getXOffsetLeft2() - 10);
                    this.xOffsetLeft2Field.method_1852(String.valueOf(this.config.getXOffsetLeft2()));
                }).method_46434(adjustX, coordY, arrowBtn, btnH).method_46431());
                this.xOffsetLeft2Field = new class_342(this.field_22793, adjustX + arrowBtn + 4, coordY, fieldW, btnH, (class_2561)class_2561.method_43470((String)""));
                this.xOffsetLeft2Field.method_1852(String.valueOf(this.config.getXOffsetLeft2()));
                this.xOffsetLeft2Field.method_1863(txt -> {
                    try {
                        this.config.setXOffsetLeft2(Integer.parseInt(txt));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                });
                this.method_37063((class_364)this.xOffsetLeft2Field);
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2192"), btn -> {
                    this.config.setXOffsetLeft2(this.config.getXOffsetLeft2() + 10);
                    this.xOffsetLeft2Field.method_1852(String.valueOf(this.config.getXOffsetLeft2()));
                }).method_46434(adjustX + arrowBtn + 4 + fieldW + 4, coordY, arrowBtn, btnH).method_46431());
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2191"), btn -> {
                    this.config.setYOffsetLeft2(this.config.getYOffsetLeft2() - 10);
                    this.yOffsetLeft2Field.method_1852(String.valueOf(this.config.getYOffsetLeft2()));
                }).method_46434(adjustX, coordY + btnH + 2, arrowBtn, btnH).method_46431());
                this.yOffsetLeft2Field = new class_342(this.field_22793, adjustX + arrowBtn + 4, coordY + btnH + 2, fieldW, btnH, (class_2561)class_2561.method_43470((String)""));
                this.yOffsetLeft2Field.method_1852(String.valueOf(this.config.getYOffsetLeft2()));
                this.yOffsetLeft2Field.method_1863(txt -> {
                    try {
                        this.config.setYOffsetLeft2(Integer.parseInt(txt));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                });
                this.method_37063((class_364)this.yOffsetLeft2Field);
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2193"), btn -> {
                    this.config.setYOffsetLeft2(this.config.getYOffsetLeft2() + 10);
                    this.yOffsetLeft2Field.method_1852(String.valueOf(this.config.getYOffsetLeft2()));
                }).method_46434(adjustX + arrowBtn + 4 + fieldW + 4, coordY + btnH + 2, arrowBtn, btnH).method_46431());
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2190"), btn -> {
                    this.config.setNumberOffsetXLeft(this.config.getNumberOffsetXLeft() - 2);
                    this.numberOffsetXLeftField.method_1852(String.valueOf(this.config.getNumberOffsetXLeft()));
                }).method_46434(rightFieldStartX, coordY, arrowBtn, btnH).method_46431());
                this.numberOffsetXLeftField = new class_342(this.field_22793, rightFieldStartX + arrowBtn + 4, coordY, fieldW, btnH, (class_2561)class_2561.method_43470((String)""));
                this.numberOffsetXLeftField.method_1852(String.valueOf(this.config.getNumberOffsetXLeft()));
                this.numberOffsetXLeftField.method_1863(txt -> {
                    try {
                        this.config.setNumberOffsetXLeft(Integer.parseInt(txt));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                });
                this.method_37063((class_364)this.numberOffsetXLeftField);
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2192"), btn -> {
                    this.config.setNumberOffsetXLeft(this.config.getNumberOffsetXLeft() + 2);
                    this.numberOffsetXLeftField.method_1852(String.valueOf(this.config.getNumberOffsetXLeft()));
                }).method_46434(rightFieldStartX + arrowBtn + 4 + fieldW + 4, coordY, arrowBtn, btnH).method_46431());
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2191"), btn -> {
                    this.config.setNumberOffsetYLeft(this.config.getNumberOffsetYLeft() - 2);
                    this.numberOffsetYLeftField.method_1852(String.valueOf(this.config.getNumberOffsetYLeft()));
                }).method_46434(rightFieldStartX, coordY + btnH + 2, arrowBtn, btnH).method_46431());
                this.numberOffsetYLeftField = new class_342(this.field_22793, rightFieldStartX + arrowBtn + 4, coordY + btnH + 2, fieldW, btnH, (class_2561)class_2561.method_43470((String)""));
                this.numberOffsetYLeftField.method_1852(String.valueOf(this.config.getNumberOffsetYLeft()));
                this.numberOffsetYLeftField.method_1863(txt -> {
                    try {
                        this.config.setNumberOffsetYLeft(Integer.parseInt(txt));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                });
                this.method_37063((class_364)this.numberOffsetYLeftField);
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2193"), btn -> {
                    this.config.setNumberOffsetYLeft(this.config.getNumberOffsetYLeft() + 2);
                    this.numberOffsetYLeftField.method_1852(String.valueOf(this.config.getNumberOffsetYLeft()));
                }).method_46434(rightFieldStartX + arrowBtn + 4 + fieldW + 4, coordY + btnH + 2, arrowBtn, btnH).method_46431());
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)this.tr("left2_coords")), btn -> {}).method_46434(adjustX, coordY += btnH * 2 + 8, fieldW + arrowBtn * 2 + 8, btnH).method_46431());
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)this.tr("number_offset_left")), btn -> {}).method_46434(rightFieldStartX, coordY, fieldW + arrowBtn * 2 + 8, btnH).method_46431());
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2190"), btn -> {
                    this.config.setXOffsetRight(this.config.getXOffsetRight() - 10);
                    this.xOffsetRightField.method_1852(String.valueOf(this.config.getXOffsetRight()));
                }).method_46434(adjustX, coordY += btnH + 6, arrowBtn, btnH).method_46431());
                this.xOffsetRightField = new class_342(this.field_22793, adjustX + arrowBtn + 4, coordY, fieldW, btnH, (class_2561)class_2561.method_43470((String)""));
                this.xOffsetRightField.method_1852(String.valueOf(this.config.getXOffsetRight()));
                this.xOffsetRightField.method_1863(txt -> {
                    try {
                        this.config.setXOffsetRight(Integer.parseInt(txt));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                });
                this.method_37063((class_364)this.xOffsetRightField);
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2192"), btn -> {
                    this.config.setXOffsetRight(this.config.getXOffsetRight() + 10);
                    this.xOffsetRightField.method_1852(String.valueOf(this.config.getXOffsetRight()));
                }).method_46434(adjustX + arrowBtn + 4 + fieldW + 4, coordY, arrowBtn, btnH).method_46431());
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2191"), btn -> {
                    this.config.setYOffsetRight(this.config.getYOffsetRight() - 10);
                    this.yOffsetRightField.method_1852(String.valueOf(this.config.getYOffsetRight()));
                }).method_46434(adjustX, coordY + btnH + 2, arrowBtn, btnH).method_46431());
                this.yOffsetRightField = new class_342(this.field_22793, adjustX + arrowBtn + 4, coordY + btnH + 2, fieldW, btnH, (class_2561)class_2561.method_43470((String)""));
                this.yOffsetRightField.method_1852(String.valueOf(this.config.getYOffsetRight()));
                this.yOffsetRightField.method_1863(txt -> {
                    try {
                        this.config.setYOffsetRight(Integer.parseInt(txt));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                });
                this.method_37063((class_364)this.yOffsetRightField);
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2193"), btn -> {
                    this.config.setYOffsetRight(this.config.getYOffsetRight() + 10);
                    this.yOffsetRightField.method_1852(String.valueOf(this.config.getYOffsetRight()));
                }).method_46434(adjustX + arrowBtn + 4 + fieldW + 4, coordY + btnH + 2, arrowBtn, btnH).method_46431());
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2190"), btn -> {
                    this.config.setNumberOffsetXRight(this.config.getNumberOffsetXRight() - 2);
                    this.numberOffsetXRightField.method_1852(String.valueOf(this.config.getNumberOffsetXRight()));
                }).method_46434(rightFieldStartX, coordY, arrowBtn, btnH).method_46431());
                this.numberOffsetXRightField = new class_342(this.field_22793, rightFieldStartX + arrowBtn + 4, coordY, fieldW, btnH, (class_2561)class_2561.method_43470((String)""));
                this.numberOffsetXRightField.method_1852(String.valueOf(this.config.getNumberOffsetXRight()));
                this.numberOffsetXRightField.method_1863(txt -> {
                    try {
                        this.config.setNumberOffsetXRight(Integer.parseInt(txt));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                });
                this.method_37063((class_364)this.numberOffsetXRightField);
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2192"), btn -> {
                    this.config.setNumberOffsetXRight(this.config.getNumberOffsetXRight() + 2);
                    this.numberOffsetXRightField.method_1852(String.valueOf(this.config.getNumberOffsetXRight()));
                }).method_46434(rightFieldStartX + arrowBtn + 4 + fieldW + 4, coordY, arrowBtn, btnH).method_46431());
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2191"), btn -> {
                    this.config.setNumberOffsetYRight(this.config.getNumberOffsetYRight() - 2);
                    this.numberOffsetYRightField.method_1852(String.valueOf(this.config.getNumberOffsetYRight()));
                }).method_46434(rightFieldStartX, coordY + btnH + 2, arrowBtn, btnH).method_46431());
                this.numberOffsetYRightField = new class_342(this.field_22793, rightFieldStartX + arrowBtn + 4, coordY + btnH + 2, fieldW, btnH, (class_2561)class_2561.method_43470((String)""));
                this.numberOffsetYRightField.method_1852(String.valueOf(this.config.getNumberOffsetYRight()));
                this.numberOffsetYRightField.method_1863(txt -> {
                    try {
                        this.config.setNumberOffsetYRight(Integer.parseInt(txt));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                });
                this.method_37063((class_364)this.numberOffsetYRightField);
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2193"), btn -> {
                    this.config.setNumberOffsetYRight(this.config.getNumberOffsetYRight() + 2);
                    this.numberOffsetYRightField.method_1852(String.valueOf(this.config.getNumberOffsetYRight()));
                }).method_46434(rightFieldStartX + arrowBtn + 4 + fieldW + 4, coordY + btnH + 2, arrowBtn, btnH).method_46431());
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)this.tr("right_coords")), btn -> {}).method_46434(adjustX, coordY += btnH * 2 + 8, fieldW + arrowBtn * 2 + 8, btnH).method_46431());
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)this.tr("number_offset_right")), btn -> {}).method_46434(rightFieldStartX, coordY, fieldW + arrowBtn * 2 + 8, btnH).method_46431());
            } else {
                if (!this.config.isVertical()) {
                    this.xOffsetField = new class_342(this.field_22793, adjustX + arrowBtn + 4, coordY, fieldW, btnH, (class_2561)class_2561.method_43470((String)""));
                    this.xOffsetField.method_1852(String.valueOf(this.config.getXOffset()));
                    this.xOffsetField.method_1863(txt -> {
                        try {
                            this.config.setXOffset(Integer.parseInt(txt));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    });
                    this.method_37063((class_364)this.xOffsetField);
                    class_4185 xDecBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)""), btn -> {
                        this.config.setXOffset(this.config.getXOffset() - 10);
                        this.xOffsetField.method_1852(String.valueOf(this.config.getXOffset()));
                    }).method_46434(adjustX, coordY, arrowBtn, btnH).method_46431();
                    class_4185 xIncBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)""), btn -> {
                        this.config.setXOffset(this.config.getXOffset() + 10);
                        this.xOffsetField.method_1852(String.valueOf(this.config.getXOffset()));
                    }).method_46434(adjustX + arrowBtn + 4 + fieldW + 4, coordY, arrowBtn, btnH).method_46431();
                    this.method_37063((class_364)xDecBtn);
                    this.method_37063((class_364)xIncBtn);
                    this.yOffsetField = new class_342(this.field_22793, adjustX + arrowBtn + 4, coordY + btnH + 2, fieldW, btnH, (class_2561)class_2561.method_43470((String)""));
                    this.yOffsetField.method_1852(String.valueOf(this.config.getYOffset()));
                    this.yOffsetField.method_1863(txt -> {
                        try {
                            this.config.setYOffset(Integer.parseInt(txt));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    });
                    this.method_37063((class_364)this.yOffsetField);
                    class_4185 yDecBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)""), btn -> {
                        this.config.setYOffset(this.config.getYOffset() - 10);
                        this.yOffsetField.method_1852(String.valueOf(this.config.getYOffset()));
                    }).method_46434(adjustX, coordY + btnH + 2, arrowBtn, btnH).method_46431();
                    class_4185 yIncBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)""), btn -> {
                        this.config.setYOffset(this.config.getYOffset() + 10);
                        this.yOffsetField.method_1852(String.valueOf(this.config.getYOffset()));
                    }).method_46434(adjustX + arrowBtn + 4 + fieldW + 4, coordY + btnH + 2, arrowBtn, btnH).method_46431();
                    this.method_37063((class_364)yDecBtn);
                    this.method_37063((class_364)yIncBtn);
                    this.numberOffsetXField = new class_342(this.field_22793, rightFieldStartX + arrowBtn + 4, coordY, fieldW, btnH, (class_2561)class_2561.method_43470((String)""));
                    this.numberOffsetXField.method_1852(String.valueOf(this.config.getNumberOffsetX()));
                    this.numberOffsetXField.method_1863(txt -> {
                        try {
                            this.config.setNumberOffsetX(Integer.parseInt(txt));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    });
                    this.method_37063((class_364)this.numberOffsetXField);
                    class_4185 numXDecBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)""), btn -> {
                        this.config.setNumberOffsetX(this.config.getNumberOffsetX() - 2);
                        this.numberOffsetXField.method_1852(String.valueOf(this.config.getNumberOffsetX()));
                    }).method_46434(rightFieldStartX, coordY, arrowBtn, btnH).method_46431();
                    class_4185 numXIncBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)""), btn -> {
                        this.config.setNumberOffsetX(this.config.getNumberOffsetX() + 2);
                        this.numberOffsetXField.method_1852(String.valueOf(this.config.getNumberOffsetX()));
                    }).method_46434(rightFieldStartX + arrowBtn + 4 + fieldW + 4, coordY, arrowBtn, btnH).method_46431();
                    this.method_37063((class_364)numXDecBtn);
                    this.method_37063((class_364)numXIncBtn);
                    this.numberOffsetYField = new class_342(this.field_22793, rightFieldStartX + arrowBtn + 4, coordY + btnH + 2, fieldW, btnH, (class_2561)class_2561.method_43470((String)""));
                    this.numberOffsetYField.method_1852(String.valueOf(this.config.getNumberOffsetY()));
                    this.numberOffsetYField.method_1863(txt -> {
                        try {
                            this.config.setNumberOffsetY(Integer.parseInt(txt));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    });
                    this.method_37063((class_364)this.numberOffsetYField);
                    class_4185 numYDecBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)""), btn -> {
                        this.config.setNumberOffsetY(this.config.getNumberOffsetY() - 2);
                        this.numberOffsetYField.method_1852(String.valueOf(this.config.getNumberOffsetY()));
                    }).method_46434(rightFieldStartX, coordY + btnH + 2, arrowBtn, btnH).method_46431();
                    class_4185 numYIncBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)""), btn -> {
                        this.config.setNumberOffsetY(this.config.getNumberOffsetY() + 2);
                        this.numberOffsetYField.method_1852(String.valueOf(this.config.getNumberOffsetY()));
                    }).method_46434(rightFieldStartX + arrowBtn + 4 + fieldW + 4, coordY + btnH + 2, arrowBtn, btnH).method_46431();
                    this.method_37063((class_364)numYDecBtn);
                    this.method_37063((class_364)numYIncBtn);
                    this.updateArrowButtons(xDecBtn, xIncBtn, yDecBtn, yIncBtn, numXDecBtn, numXIncBtn, numYDecBtn, numYIncBtn);
                }
                if (this.config.isVertical()) {
                    this.xOffsetVerticalField = new class_342(this.field_22793, adjustX + arrowBtn + 4, coordY, fieldW, btnH, (class_2561)class_2561.method_43470((String)""));
                    this.xOffsetVerticalField.method_1852(String.valueOf(this.config.getXOffsetLeftVertical()));
                    this.xOffsetVerticalField.method_1863(txt -> {
                        try {
                            this.config.setXOffsetLeftVertical(Integer.parseInt(txt));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    });
                    this.method_37063((class_364)this.xOffsetVerticalField);
                    class_4185 xDecVBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2190"), btn -> {
                        this.config.setXOffsetLeftVertical(this.config.getXOffsetLeftVertical() - 10);
                        this.xOffsetVerticalField.method_1852(String.valueOf(this.config.getXOffsetLeftVertical()));
                    }).method_46434(adjustX, coordY, arrowBtn, btnH).method_46431();
                    class_4185 xIncVBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2192"), btn -> {
                        this.config.setXOffsetLeftVertical(this.config.getXOffsetLeftVertical() + 10);
                        this.xOffsetVerticalField.method_1852(String.valueOf(this.config.getXOffsetLeftVertical()));
                    }).method_46434(adjustX + arrowBtn + 4 + fieldW + 4, coordY, arrowBtn, btnH).method_46431();
                    this.method_37063((class_364)xDecVBtn);
                    this.method_37063((class_364)xIncVBtn);
                    this.yOffsetVerticalField = new class_342(this.field_22793, adjustX + arrowBtn + 4, coordY + btnH + 2, fieldW, btnH, (class_2561)class_2561.method_43470((String)""));
                    this.yOffsetVerticalField.method_1852(String.valueOf(this.config.getYOffsetLeftVertical()));
                    this.yOffsetVerticalField.method_1863(txt -> {
                        try {
                            this.config.setYOffsetLeftVertical(Integer.parseInt(txt));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    });
                    this.method_37063((class_364)this.yOffsetVerticalField);
                    class_4185 yDecVBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2191"), btn -> {
                        this.config.setYOffsetLeftVertical(this.config.getYOffsetLeftVertical() - 10);
                        this.yOffsetVerticalField.method_1852(String.valueOf(this.config.getYOffsetLeftVertical()));
                    }).method_46434(adjustX, coordY + btnH + 2, arrowBtn, btnH).method_46431();
                    class_4185 yIncVBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2193"), btn -> {
                        this.config.setYOffsetLeftVertical(this.config.getYOffsetLeftVertical() + 10);
                        this.yOffsetVerticalField.method_1852(String.valueOf(this.config.getYOffsetLeftVertical()));
                    }).method_46434(adjustX + arrowBtn + 4 + fieldW + 4, coordY + btnH + 2, arrowBtn, btnH).method_46431();
                    this.method_37063((class_364)yDecVBtn);
                    this.method_37063((class_364)yIncVBtn);
                    this.numberOffsetXVerticalField = new class_342(this.field_22793, rightFieldStartX + arrowBtn + 4, coordY, fieldW, btnH, (class_2561)class_2561.method_43470((String)""));
                    this.numberOffsetXVerticalField.method_1852(String.valueOf(this.config.getNumberOffsetXLeftVertical()));
                    this.numberOffsetXVerticalField.method_1863(txt -> {
                        try {
                            this.config.setNumberOffsetXLeftVertical(Integer.parseInt(txt));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    });
                    this.method_37063((class_364)this.numberOffsetXVerticalField);
                    class_4185 numXDecVBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2190"), btn -> {
                        this.config.setNumberOffsetXLeftVertical(this.config.getNumberOffsetXLeftVertical() - 2);
                        this.numberOffsetXVerticalField.method_1852(String.valueOf(this.config.getNumberOffsetXLeftVertical()));
                    }).method_46434(rightFieldStartX, coordY, arrowBtn, btnH).method_46431();
                    class_4185 numXIncVBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2192"), btn -> {
                        this.config.setNumberOffsetXLeftVertical(this.config.getNumberOffsetXLeftVertical() + 2);
                        this.numberOffsetXVerticalField.method_1852(String.valueOf(this.config.getNumberOffsetXLeftVertical()));
                    }).method_46434(rightFieldStartX + arrowBtn + 4 + fieldW + 4, coordY, arrowBtn, btnH).method_46431();
                    this.method_37063((class_364)numXDecVBtn);
                    this.method_37063((class_364)numXIncVBtn);
                    this.numberOffsetYVerticalField = new class_342(this.field_22793, rightFieldStartX + arrowBtn + 4, coordY + btnH + 2, fieldW, btnH, (class_2561)class_2561.method_43470((String)""));
                    this.numberOffsetYVerticalField.method_1852(String.valueOf(this.config.getNumberOffsetYLeftVertical()));
                    this.numberOffsetYVerticalField.method_1863(txt -> {
                        try {
                            this.config.setNumberOffsetYLeftVertical(Integer.parseInt(txt));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    });
                    this.method_37063((class_364)this.numberOffsetYVerticalField);
                    class_4185 numYDecVBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2191"), btn -> {
                        this.config.setNumberOffsetYLeftVertical(this.config.getNumberOffsetYLeftVertical() - 2);
                        this.numberOffsetYVerticalField.method_1852(String.valueOf(this.config.getNumberOffsetYLeftVertical()));
                    }).method_46434(rightFieldStartX, coordY + btnH + 2, arrowBtn, btnH).method_46431();
                    class_4185 numYIncVBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2193"), btn -> {
                        this.config.setNumberOffsetYLeftVertical(this.config.getNumberOffsetYLeftVertical() + 2);
                        this.numberOffsetYVerticalField.method_1852(String.valueOf(this.config.getNumberOffsetYLeftVertical()));
                    }).method_46434(rightFieldStartX + arrowBtn + 4 + fieldW + 4, coordY + btnH + 2, arrowBtn, btnH).method_46431();
                    this.method_37063((class_364)numYDecVBtn);
                    this.method_37063((class_364)numYIncVBtn);
                }
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)this.tr("left2_coords")), btn -> {}).method_46434(adjustX, coordY += btnH * 2 + 8, fieldW + arrowBtn * 2 + 8, btnH).method_46431());
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)this.tr("number_offset_left")), btn -> {}).method_46434(rightFieldStartX, coordY, fieldW + arrowBtn * 2 + 8, btnH).method_46431());
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)this.tr("right_coords")), btn -> {}).method_46434(adjustX, coordY += btnH + 6, fieldW + arrowBtn * 2 + 8, btnH).method_46431());
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)this.tr("number_offset_right")), btn -> {}).method_46434(rightFieldStartX, coordY, fieldW + arrowBtn * 2 + 8, btnH).method_46431());
            }
            int midW = Math.max(btnW, 160);
            int midX = winW / 2 - midW / 2;
            int defY = winH - btnH * 2 - marginY * 3;
            int doneY = winH - btnH - marginY * 2;
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)this.tr("defaults")), btn -> {
                this.config.resetToDefaults();
                this.field_22787.method_1507((class_437)new SimpleConfigScreen(this.parent));
            }).method_46434(midX, defY, midW, btnH).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)this.tr("done")), btn -> this.field_22787.method_1507(this.parent)).method_46434(midX, doneY, midW, btnH).method_46431());
        }

        public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
            super.method_25394(context, mouseX, mouseY, delta);
            if (this.config.isVisible()) {
                ArmorHudOverlay.renderPreview(context, this.field_22789, this.field_22790, this.config);
            }
            context.method_25300(this.field_22793, this.tr(""), this.field_22789 / 2, 12, 0xFFFFFF);
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)this.tr("")), this.field_22789 / 2, 110, 0xAAAAAA);
            context.method_25303(this.field_22793, "", 8, this.field_22790 - 18, 0x777777);
        }

        private void updateArrowButtons(class_4185 xDec, class_4185 xInc, class_4185 yDec, class_4185 yInc, class_4185 numXDec, class_4185 numXInc, class_4185 numYDec, class_4185 numYInc) {
            if (this.config.isVertical()) {
                xDec.method_25355((class_2561)class_2561.method_43470((String)"\u2190"));
                xInc.method_25355((class_2561)class_2561.method_43470((String)"\u2192"));
                numXDec.method_25355((class_2561)class_2561.method_43470((String)"\u2190"));
                numXInc.method_25355((class_2561)class_2561.method_43470((String)"\u2192"));
                yDec.method_25355((class_2561)class_2561.method_43470((String)"\u2191"));
                yInc.method_25355((class_2561)class_2561.method_43470((String)"\u2193"));
                numYDec.method_25355((class_2561)class_2561.method_43470((String)"\u2191"));
                numYInc.method_25355((class_2561)class_2561.method_43470((String)"\u2193"));
            } else {
                xDec.method_25355((class_2561)class_2561.method_43470((String)"\u2190"));
                xInc.method_25355((class_2561)class_2561.method_43470((String)"\u2192"));
                numXDec.method_25355((class_2561)class_2561.method_43470((String)"\u2190"));
                numXInc.method_25355((class_2561)class_2561.method_43470((String)"\u2192"));
                yDec.method_25355((class_2561)class_2561.method_43470((String)"\u2191"));
                yInc.method_25355((class_2561)class_2561.method_43470((String)"\u2193"));
                numYDec.method_25355((class_2561)class_2561.method_43470((String)"\u2191"));
                numYInc.method_25355((class_2561)class_2561.method_43470((String)"\u2193"));
            }
        }
    }
}

