/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final Logger LOGGER = LogManager.getLogger(Config.class);
    public static final ForgeConfigSpec SPEC;
    public static ForgeConfigSpec.IntValue START_MONEY;
    public static ForgeConfigSpec.IntValue MONEY_LOSS_ON_DEATH;
    public static ForgeConfigSpec.BooleanValue PAYCHECK_ENABLED;
    public static ForgeConfigSpec.IntValue PAYCHECK_AMOUNT;
    public static ForgeConfigSpec.BooleanValue VILLAGER_TRADES_ENABLED;
    public static ForgeConfigSpec.IntValue TRADE_L1_RAW_IRON_AMOUNT;
    public static ForgeConfigSpec.IntValue TRADE_L2_DIAMOND_AMOUNT;
    public static ForgeConfigSpec.IntValue TRADE_L3_RAW_COPPER_AMOUNT;
    public static ForgeConfigSpec.IntValue TRADE_L4_RAW_IRON_AMOUNT;
    public static ForgeConfigSpec.IntValue TRADE_L4_DIAMOND_AMOUNT;
    public static ForgeConfigSpec.IntValue TRADE_L5_GOLDEN_APPLE_AMOUNT;
    public static ForgeConfigSpec.IntValue TRADE_L5_NETHER_STAR_AMOUNT;

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        LOGGER.info("Initialized Saro's Money Mod config");
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("General Money Settings");
        START_MONEY = builder.comment("Starting money for new players").defineInRange("startMoney", 100, 0, Integer.MAX_VALUE);
        MONEY_LOSS_ON_DEATH = builder.comment("Amount of money lost on death (0 for none)").defineInRange("moneyLossOnDeath", 0, 0, Integer.MAX_VALUE);
        PAYCHECK_ENABLED = builder.comment("Enable the paycheck system").define("paycheckEnabled", false);
        PAYCHECK_AMOUNT = builder.comment("Amount of money given as paycheck").defineInRange("paycheckAmount", 50, 0, Integer.MAX_VALUE);
        builder.comment("Villager Settings");
        VILLAGER_TRADES_ENABLED = builder.comment("Enable villager trades").define("villagerTradesEnabled", true);
        builder.comment("Villager Trade Item Amounts");
        TRADE_L1_RAW_IRON_AMOUNT = builder.comment("Level 1 trade - raw iron amount").defineInRange("tradeL1RawIronAmount", 5, 1, Integer.MAX_VALUE);
        TRADE_L2_DIAMOND_AMOUNT = builder.comment("Level 2 trade - diamond amount").defineInRange("tradeL2DiamondAmount", 3, 1, Integer.MAX_VALUE);
        TRADE_L3_RAW_COPPER_AMOUNT = builder.comment("Level 3 trade - raw copper amount").defineInRange("tradeL3RawCopperAmount", 5, 1, Integer.MAX_VALUE);
        TRADE_L4_RAW_IRON_AMOUNT = builder.comment("Level 4 trade - raw iron amount").defineInRange("tradeL4RawIronAmount", 3, 1, Integer.MAX_VALUE);
        TRADE_L4_DIAMOND_AMOUNT = builder.comment("Level 4 trade - diamond amount").defineInRange("tradeL4DiamondAmount", 2, 1, Integer.MAX_VALUE);
        TRADE_L5_GOLDEN_APPLE_AMOUNT = builder.comment("Level 5 trade - enchanted golden apple amount").defineInRange("tradeL5GoldenAppleAmount", 1, 1, Integer.MAX_VALUE);
        TRADE_L5_NETHER_STAR_AMOUNT = builder.comment("Level 5 trade - nether star amount").defineInRange("tradeL5NetherStarAmount", 1, 1, Integer.MAX_VALUE);
        SPEC = builder.build();
    }
}

