/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.event;

import de.sarocesch.sarosmoneymod.Config;
import de.sarocesch.sarosmoneymod.SarosMoneyMod;
import de.sarocesch.sarosmoneymod.init.ModItems;
import de.sarocesch.sarosmoneymod.init.ModVillagers;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.villager.Villager;
import net.minecraft.world.entity.npc.villager.VillagerProfession;
import net.minecraft.world.entity.npc.villager.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="saros__money_mod")
public class ModEvents {
    @SubscribeEvent
    public static void onVillagerInteract(PlayerInteractEvent.EntityInteract event) {
        Entity entity = event.getTarget();
        if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            SarosMoneyMod.LOGGER.debug("Player interacted with villager: " + String.valueOf(villager));
            SarosMoneyMod.LOGGER.debug("Villager profession: " + String.valueOf(ForgeRegistries.VILLAGER_PROFESSIONS.getKey((Object)((VillagerProfession)villager.getVillagerData().profession().value()))));
            SarosMoneyMod.LOGGER.debug("Our banker profession: " + String.valueOf(ForgeRegistries.VILLAGER_PROFESSIONS.getKey((Object)((VillagerProfession)ModVillagers.BANKER.get()))));
            if (villager.getVillagerData().profession().value() == ModVillagers.BANKER.get()) {
                SarosMoneyMod.LOGGER.info("Player interacted with banker villager");
                if (!((Boolean)Config.VILLAGER_TRADES_ENABLED.get()).booleanValue()) {
                    SarosMoneyMod.LOGGER.debug("Villager trades disabled in config");
                    return;
                }
                if (event.getHand() == InteractionHand.MAIN_HAND) {
                    SarosMoneyMod.LOGGER.info("Player right-clicked on banker villager - trading should open");
                }
            }
        }
    }

    @SubscribeEvent
    public static void addCustomTrades(VillagerTradesEvent event) {
        ResourceKey bankerKey = ModVillagers.BANKER.getKey();
        SarosMoneyMod.LOGGER.debug("VillagerTradesEvent fired for profession: " + String.valueOf(event.getType()));
        SarosMoneyMod.LOGGER.debug("Our banker profession key: " + String.valueOf(bankerKey));
        SarosMoneyMod.LOGGER.debug("Profession match: " + event.getType().equals((Object)bankerKey));
        SarosMoneyMod.LOGGER.debug("villagerTradesEnabled: " + String.valueOf(Config.VILLAGER_TRADES_ENABLED.get()));
        if (!((Boolean)Config.VILLAGER_TRADES_ENABLED.get()).booleanValue()) {
            SarosMoneyMod.LOGGER.debug("Villager trades disabled in config");
            return;
        }
        if (event.getType().equals((Object)bankerKey)) {
            SarosMoneyMod.LOGGER.info("Adding trades for banker profession");
            Int2ObjectMap trades = event.getTrades();
            ((List)trades.get(1)).add(new VillagerTrades.ItemListing(){

                public MerchantOffer getOffer(ServerLevel level, Entity entity, RandomSource random) {
                    return new MerchantOffer(new ItemCost((ItemLike)Items.RAW_IRON, ((Integer)Config.TRADE_L1_RAW_IRON_AMOUNT.get()).intValue()), Optional.empty(), new ItemStack((ItemLike)ModItems.EURO_1.get(), 1), 10, 8, 1, 0.0f);
                }
            });
            ((List)trades.get(2)).add(new VillagerTrades.ItemListing(){

                public MerchantOffer getOffer(ServerLevel level, Entity entity, RandomSource random) {
                    return new MerchantOffer(new ItemCost((ItemLike)Items.DIAMOND, ((Integer)Config.TRADE_L2_DIAMOND_AMOUNT.get()).intValue()), Optional.empty(), new ItemStack((ItemLike)ModItems.EURO_5.get(), 1), 10, 8, 1, 0.0f);
                }
            });
            ((List)trades.get(3)).add(new VillagerTrades.ItemListing(){

                public MerchantOffer getOffer(ServerLevel level, Entity entity, RandomSource random) {
                    return new MerchantOffer(new ItemCost((ItemLike)Items.RAW_COPPER, ((Integer)Config.TRADE_L3_RAW_COPPER_AMOUNT.get()).intValue()), Optional.empty(), new ItemStack((ItemLike)ModItems.EURO_1.get(), 1), 10, 8, 1, 0.0f);
                }
            });
            ((List)trades.get(4)).add(new VillagerTrades.ItemListing(){

                public MerchantOffer getOffer(ServerLevel level, Entity entity, RandomSource random) {
                    return new MerchantOffer(new ItemCost((ItemLike)Items.RAW_IRON, ((Integer)Config.TRADE_L4_RAW_IRON_AMOUNT.get()).intValue()), Optional.empty(), new ItemStack((ItemLike)ModItems.EURO_1.get(), 1), 10, 8, 1, 0.0f);
                }
            });
            ((List)trades.get(4)).add(new VillagerTrades.ItemListing(){

                public MerchantOffer getOffer(ServerLevel level, Entity entity, RandomSource random) {
                    return new MerchantOffer(new ItemCost((ItemLike)Items.DIAMOND, ((Integer)Config.TRADE_L4_DIAMOND_AMOUNT.get()).intValue()), Optional.empty(), new ItemStack((ItemLike)ModItems.EURO_5.get(), 1), 10, 8, 1, 0.0f);
                }
            });
            ((List)trades.get(5)).add(new VillagerTrades.ItemListing(){

                public MerchantOffer getOffer(ServerLevel level, Entity entity, RandomSource random) {
                    return new MerchantOffer(new ItemCost((ItemLike)Items.ENCHANTED_GOLDEN_APPLE, ((Integer)Config.TRADE_L5_GOLDEN_APPLE_AMOUNT.get()).intValue()), Optional.empty(), new ItemStack((ItemLike)ModItems.EURO_500.get(), 1), 10, 8, 1, 0.0f);
                }
            });
            ((List)trades.get(5)).add(new VillagerTrades.ItemListing(){

                public MerchantOffer getOffer(ServerLevel level, Entity entity, RandomSource random) {
                    return new MerchantOffer(new ItemCost((ItemLike)Items.NETHER_STAR, ((Integer)Config.TRADE_L5_NETHER_STAR_AMOUNT.get()).intValue()), Optional.empty(), new ItemStack((ItemLike)ModItems.EURO_200.get(), 1), 10, 8, 1, 0.0f);
                }
            });
            SarosMoneyMod.LOGGER.info("Successfully added all trades for banker profession");
        }
    }
}

