/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.network;

import de.sarocesch.sarosmoneymod.SarosMoneyMod;
import de.sarocesch.sarosmoneymod.data.BalanceManager;
import de.sarocesch.sarosmoneymod.procedures.DepositProcedure;
import de.sarocesch.sarosmoneymod.procedures.WithdrawProcedure;
import de.sarocesch.sarosmoneymod.world.inventory.ATMGUIMenu;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class ATMGUIButtonMessage {
    private final int buttonID;
    private final BlockPos pos;
    private final String withdrawValue;
    public static final Identifier ID = Identifier.fromNamespaceAndPath((String)"saros__money_mod", (String)"atmgui_button");

    public ATMGUIButtonMessage(int buttonID, BlockPos pos, String withdrawValue) {
        this.buttonID = buttonID;
        this.pos = pos;
        this.withdrawValue = withdrawValue;
    }

    public ATMGUIButtonMessage(FriendlyByteBuf buffer) {
        this(buffer.readInt(), buffer.readBlockPos(), buffer.readUtf(Short.MAX_VALUE));
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.buttonID);
        buffer.writeBlockPos(this.pos);
        buffer.writeUtf(this.withdrawValue, Short.MAX_VALUE);
    }

    public static void handle(ATMGUIButtonMessage message, Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ServerLevel world = serverPlayer.level();
            HashMap<String, Object> guistate = ATMGUIMenu.guistate;
            try {
                String value = message.withdrawValue;
                if (value == null || value.trim().isEmpty()) {
                    value = "0";
                }
                switch (message.buttonID) {
                    case 0: {
                        WithdrawProcedure.execute((Entity)serverPlayer, guistate, value, serverPlayer);
                        break;
                    }
                    case 1: {
                        DepositProcedure.execute((Entity)serverPlayer, guistate, value, serverPlayer);
                        break;
                    }
                    default: {
                        SarosMoneyMod.LOGGER.warn("Unknown button ID: " + message.buttonID);
                    }
                }
                double playerBalance = BalanceManager.getPlayerBalance(serverPlayer);
                int newBalance = (int)(playerBalance * 100.0);
                AbstractContainerMenu abstractContainerMenu = serverPlayer.containerMenu;
                if (abstractContainerMenu instanceof ATMGUIMenu) {
                    ATMGUIMenu menu = (ATMGUIMenu)abstractContainerMenu;
                    menu.balance.set(newBalance);
                    menu.broadcastChanges();
                }
            }
            catch (Exception e) {
                SarosMoneyMod.LOGGER.error("Error handling ATM button click", (Throwable)e);
            }
        } else {
            SarosMoneyMod.LOGGER.error("Player is not a ServerPlayer!");
        }
    }

    public int getButtonID() {
        return this.buttonID;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public String getWithdrawValue() {
        return this.withdrawValue;
    }
}

