/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.handlers;

import de.sarocesch.sarosmoneymod.handlers.ContainerHandler;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void handleSignUpdate(@Nullable ServerPlayer player, BlockPos signPos) {
        BlockEntity blockEntity;
        ServerLevel level;
        ServerLevel serverLevel = level = player != null ? player.level() : null;
        if (level == null) {
            LOGGER.warn("[Shop] Cannot process sign update: invalid level");
            return;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel2 = level;
            serverLevel2.getChunk(signPos.getX() >> 4, signPos.getZ() >> 4);
        }
        if ((blockEntity = level.getBlockEntity(signPos)) instanceof SignBlockEntity) {
            MutableComponent itemName;
            boolean updated;
            SignBlockEntity sign = (SignBlockEntity)blockEntity;
            sign.setChanged();
            BlockState signState = level.getBlockState(signPos);
            BlockPos containerPos = ContainerHandler.getAttachedContainerPos((Level)level, signPos, signState);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel3 = level;
                serverLevel3.getChunk(containerPos.getX() >> 4, containerPos.getZ() >> 4);
                BlockEntity containerEntity = level.getBlockEntity(containerPos);
                if (containerEntity != null) {
                    containerEntity.setChanged();
                }
            }
            if (updated = ServerHandler.updateSignText(sign, containerPos, itemName = ServerHandler.getItemName((Level)level, containerPos))) {
                ServerHandler.syncSignWithClient((Level)level, signPos, sign);
                if (level.getServer() != null) {
                    level.getServer().execute(() -> ServerHandler.lambda$handleSignUpdate$0((Level)level, signPos, sign, signState));
                }
            }
        }
    }

    private static boolean updateSignText(SignBlockEntity sign, BlockPos containerPos, MutableComponent itemName) {
        SignText frontText = sign.getText(true);
        Component[] lines = frontText.getMessages(true);
        String firstLine = ServerHandler.stripFormatting(lines[0]).trim().toLowerCase();
        boolean isShop = firstLine.equals("[shop]");
        boolean isBuy = firstLine.equals("[buy]");
        boolean isSell = firstLine.equals("[sell]");
        if (!(isShop || isBuy || isSell)) {
            return false;
        }
        ChatFormatting color = isBuy ? ChatFormatting.BLUE : (isSell ? ChatFormatting.GOLD : ChatFormatting.DARK_GREEN);
        Component[] newLines = new Component[4];
        newLines[0] = Component.literal((String)(isShop ? "[SHOP]" : (isBuy ? "[BUY]" : "[SELL]"))).withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(color));
        newLines[1] = lines[1].copy();
        newLines[2] = itemName;
        try {
            String priceText = ServerHandler.stripFormatting(lines[3]).replaceAll("[^\\d.,]", "").replace(',', '.');
            if (priceText.isEmpty()) {
                throw new NumberFormatException("Empty price");
            }
            double price = Double.parseDouble(priceText);
            newLines[3] = Component.literal((String)("$" + String.format("%.2f", price))).withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(color));
        }
        catch (Exception e) {
            LOGGER.error("Invalid price format: {}", (Object)e.getMessage());
            newLines[3] = Component.literal((String)"Invalid Price").withStyle(Style.EMPTY.withColor(ChatFormatting.RED));
        }
        if (itemName.getString().isEmpty()) {
            LOGGER.error("[Shop Error] Missing item in container at {}", (Object)containerPos);
            newLines[2] = Component.literal((String)"!NO ITEM!").withStyle(ChatFormatting.RED);
        }
        SignText newSignText = new SignText(newLines, newLines, frontText.getColor(), frontText.hasGlowingText());
        sign.setText(newSignText, true);
        sign.setText(newSignText, false);
        sign.setChanged();
        if (sign.getLevel() != null) {
            sign.getLevel().getChunkAt(sign.getBlockPos()).markUnsaved();
        }
        return true;
    }

    private static void syncSignWithClient(Level level, BlockPos pos, SignBlockEntity sign) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ClientboundBlockEntityDataPacket packet = ClientboundBlockEntityDataPacket.create((BlockEntity)sign);
        serverLevel.getChunkSource().chunkMap.getPlayers(serverLevel.getChunkAt(pos).getPos(), false).forEach(player -> player.connection.send((Packet)packet));
        BlockState state = level.getBlockState(pos);
        level.sendBlockUpdated(pos, state, state, 3);
    }

    private static MutableComponent getItemName(Level level, BlockPos pos) {
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof Container) {
            Container container = (Container)be;
            for (int i = 0; i < container.getContainerSize(); ++i) {
                ItemStack stack = container.getItem(i);
                if (stack.isEmpty()) continue;
                String rawName = ServerHandler.stripFormatting(stack.getHoverName());
                return Component.literal((String)rawName).withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)));
            }
        }
        return Component.literal((String)"").withStyle(Style.EMPTY);
    }

    private static String stripFormatting(Component component) {
        return component.getString().replaceAll("\u00a7[0-9a-fk-or]", "");
    }

    private static Item getItemFromContainer(BlockPos containerPos, Level level) {
        BlockEntity be = level.getBlockEntity(containerPos);
        if (be instanceof Container) {
            Container container = (Container)be;
            for (int i = 0; i < container.getContainerSize(); ++i) {
                ItemStack stack = container.getItem(i);
                if (stack.isEmpty()) continue;
                return stack.getItem();
            }
        }
        return Items.AIR;
    }

    private static /* synthetic */ void lambda$handleSignUpdate$0(Level level, BlockPos signPos, SignBlockEntity sign, BlockState signState) {
        ServerHandler.syncSignWithClient(level, signPos, sign);
        level.sendBlockUpdated(signPos, signState, signState, 3);
    }
}

