/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;

public class BalanceData
extends SavedData {
    private static final String DATA_NAME = "sarosmoneymod_balance";
    private final Map<String, Double> balances;

    public BalanceData() {
        this(new HashMap<String, Double>());
    }

    public BalanceData(Map<String, Double> balances) {
        this.balances = balances;
    }

    public static Codec<BalanceData> codec() {
        return RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.DOUBLE).fieldOf("balances").forGetter(d -> d.balances)).apply((Applicative)instance, BalanceData::new));
    }

    public static BalanceData load(CompoundTag compound, HolderLookup.Provider provider) {
        BalanceData data = new BalanceData();
        if (compound.contains("balances")) {
            CompoundTag mapTag = compound.getCompound("balances").orElse(new CompoundTag());
            for (String key : mapTag.keySet()) {
                if (!mapTag.contains(key)) continue;
                if (mapTag.getDouble(key).isPresent()) {
                    data.balances.put(key, mapTag.getDouble(key).orElse(0.0));
                    continue;
                }
                data.balances.put(key, (double)mapTag.getInt(key).orElse(0));
            }
        }
        return data;
    }

    public CompoundTag save(CompoundTag compound, HolderLookup.Provider provider) {
        CompoundTag mapTag = new CompoundTag();
        for (Map.Entry<String, Double> entry : this.balances.entrySet()) {
            mapTag.putDouble(entry.getKey(), entry.getValue().doubleValue());
        }
        compound.put("balances", (Tag)mapTag);
        return compound;
    }

    public double getBalance(String playerUUID) {
        return this.balances.getOrDefault(playerUUID, 0.0);
    }

    public boolean containsBalance(String playerUUID) {
        return this.balances.containsKey(playerUUID);
    }

    public void setBalance(String playerUUID, double balance) {
        this.balances.put(playerUUID, balance);
        this.setDirty();
    }

    public Map<String, Double> getAllBalances() {
        return new HashMap<String, Double>(this.balances);
    }

    public static BalanceData get(MinecraftServer server) {
        if (server == null) {
            throw new IllegalArgumentException("Server instance is null");
        }
        ServerLevel level = server.overworld();
        return (BalanceData)level.getDataStorage().computeIfAbsent(new SavedDataType(DATA_NAME, () -> new BalanceData(), BalanceData.codec(), null));
    }
}

