/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.listener;

import de.sarocesch.sarosmoneymod.Config;
import de.sarocesch.sarosmoneymod.data.BalanceData;
import de.sarocesch.sarosmoneymod.data.BalanceManager;
import de.sarocesch.sarosmoneymod.data.BalanceMigrator;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class BalanceJoin {
    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        new BalanceJoin();
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    private static class ClientEvents {
        private ClientEvents() {
        }

        @SubscribeEvent
        public static void clientLoad(FMLClientSetupEvent event) {
        }
    }

    @Mod.EventBusSubscriber
    private static class ForgeBusEvents {
        private ForgeBusEvents() {
        }

        @SubscribeEvent
        public static void serverLoad(ServerStartingEvent event) {
            MinecraftServer server = event.getServer();
            BalanceMigrator.migrateOldData(server);
        }

        @SubscribeEvent
        public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
            if (event.getEntity() instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)event.getEntity();
                MinecraftServer server = player.getServer();
                if (server == null) {
                    return;
                }
                BalanceMigrator.migrateOldData(server);
                if (!BalanceData.get(server).containsBalance(player.getUUID().toString())) {
                    BalanceManager.setBalance(player.getUUID().toString(), ((Integer)Config.START_MONEY.get()).intValue());
                }
            }
        }
    }
}

