/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.listener;

import de.sarocesch.sarosmoneymod.Config;
import de.sarocesch.sarosmoneymod.data.BalanceManager;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class Paycheck {
    private static long lastPaycheckTime = 0L;
    private static final long PAYCHECK_INTERVAL = TimeUnit.MINUTES.toMillis(30L);

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new Paycheck());
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        MinecraftServer server = event.getServer();
        long currentTime = System.currentTimeMillis();
        if (((Boolean)Config.PAYCHECK_ENABLED.get()).booleanValue() && currentTime - lastPaycheckTime >= PAYCHECK_INTERVAL) {
            lastPaycheckTime = currentTime;
            Paycheck.payPlayers(server);
        }
    }

    private static void payPlayers(MinecraftServer server) {
        List players = server.getPlayerList().getPlayers();
        for (ServerPlayer player : players) {
            String playerUUID = player.getUUID().toString();
            int paycheckAmount = (Integer)Config.PAYCHECK_AMOUNT.get();
            BalanceManager.addMoneyToPlayer(server, playerUUID, paycheckAmount);
            player.sendSystemMessage((Component)Component.translatable((String)"message.sarosmoneymod.paycheck", (Object[])new Object[]{paycheckAmount}));
        }
    }
}

