/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.procedures;

import de.sarocesch.sarosmoneymod.data.BalanceManager;
import de.sarocesch.sarosmoneymod.init.ModItems;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class WithdrawProcedure {
    public static void execute(Entity entity, HashMap guistate, String withdrawValue, ServerPlayer player) {
        Player _player;
        if (entity == null || guistate == null) {
            return;
        }
        if (entity instanceof Player && !(_player = (Player)entity).level().isClientSide()) {
            try {
                int amount = Integer.parseInt(withdrawValue);
                if (amount > 0) {
                    String playerUUID = _player.getUUID().toString();
                    double currentBalance = BalanceManager.getBalance(playerUUID);
                    if ((double)amount <= currentBalance) {
                        Map<Integer, ItemStack> items = WithdrawProcedure.convertAmountToItems(amount);
                        boolean canFitAllItems = WithdrawProcedure.canFitItems(_player, items);
                        if (canFitAllItems) {
                            WithdrawProcedure.addItemsToPlayerInventory(_player, items);
                            double newBalance = currentBalance - (double)amount;
                            BalanceManager.setBalance(playerUUID, newBalance);
                            _player.displayClientMessage((Component)Component.literal((String)("\u00a79" + Component.translatable((String)"lang.withdraw.previous_balance").getString() + " " + currentBalance)), false);
                            _player.displayClientMessage((Component)Component.literal((String)("\u00a7a" + Component.translatable((String)"lang.withdraw.withdrawn_amount").getString() + " " + amount)), false);
                            _player.displayClientMessage((Component)Component.literal((String)("\u00a76" + Component.translatable((String)"lang.withdraw.new_balance").getString() + " " + newBalance)), false);
                            ((EditBox)guistate.get("text:withdraw")).setValue("");
                        } else {
                            _player.displayClientMessage((Component)Component.literal((String)("\u00a7c" + Component.translatable((String)"lang.withdraw.not_enough_inventory").getString())), false);
                        }
                    } else {
                        _player.displayClientMessage((Component)Component.literal((String)("\u00a7c" + Component.translatable((String)"lang.withdraw.not_enough_balance").getString())), false);
                    }
                } else {
                    _player.displayClientMessage((Component)Component.literal((String)("\u00a7c" + Component.translatable((String)"lang.withdraw.enter_positive_number").getString())), false);
                }
            }
            catch (NumberFormatException e) {
                _player.displayClientMessage((Component)Component.literal((String)("\u00a7c" + Component.translatable((String)"lang.withdraw.enter_valid_number").getString())), false);
            }
        }
    }

    private static Map<Integer, ItemStack> convertAmountToItems(int amount) {
        HashMap<Integer, ItemStack> items = new HashMap<Integer, ItemStack>();
        int remaining = amount;
        int[] denominations = new int[]{500, 200, 100, 50, 20, 10, 5, 2, 1};
        ItemStack[] itemStacks = new ItemStack[]{new ItemStack((ItemLike)ModItems.EURO_500.get()), new ItemStack((ItemLike)ModItems.EURO_200.get()), new ItemStack((ItemLike)ModItems.EURO_100.get()), new ItemStack((ItemLike)ModItems.EURO_50.get()), new ItemStack((ItemLike)ModItems.EURO_20.get()), new ItemStack((ItemLike)ModItems.EURO_10.get()), new ItemStack((ItemLike)ModItems.EURO_5.get()), new ItemStack((ItemLike)ModItems.EURO_2.get()), new ItemStack((ItemLike)ModItems.EURO_1.get())};
        for (int i = 0; i < denominations.length; ++i) {
            int denom = denominations[i];
            int count = remaining / denom;
            if (count <= 0) continue;
            ItemStack stack = itemStacks[i].copy();
            stack.setCount(count);
            items.put(denom, stack);
            remaining %= denom;
        }
        return items;
    }

    private static boolean canFitItems(Player player, Map<Integer, ItemStack> items) {
        int freeSlots = 0;
        int slotsNeeded = 0;
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            if (!player.getInventory().getItem(i).isEmpty()) continue;
            ++freeSlots;
        }
        for (ItemStack stack : items.values()) {
            int remainingCount = stack.getCount();
            for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                int spaceInStack;
                ItemStack invStack = player.getInventory().getItem(i);
                if (invStack.isEmpty() || !invStack.is(stack.getItem()) || (remainingCount -= (spaceInStack = invStack.getMaxStackSize() - invStack.getCount())) > 0) continue;
                remainingCount = 0;
                break;
            }
            slotsNeeded += (remainingCount + stack.getMaxStackSize() - 1) / stack.getMaxStackSize();
        }
        return freeSlots >= slotsNeeded;
    }

    private static void addItemsToPlayerInventory(Player player, Map<Integer, ItemStack> items) {
        for (ItemStack stack : items.values()) {
            while (!stack.isEmpty()) {
                int remainingCount = stack.getCount();
                for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                    ItemStack invStack = player.getInventory().getItem(i);
                    if (invStack.isEmpty() || !invStack.is(stack.getItem())) continue;
                    int spaceInStack = invStack.getMaxStackSize() - invStack.getCount();
                    if (remainingCount <= spaceInStack) {
                        invStack.grow(remainingCount);
                        stack.setCount(0);
                        break;
                    }
                    invStack.grow(spaceInStack);
                    remainingCount -= spaceInStack;
                }
                if (stack.isEmpty()) continue;
                player.addItem(stack.split(stack.getMaxStackSize()));
            }
        }
    }
}

