/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.client.gui;

import de.sarocesch.sarosmoneymod.network.ATMGUIButtonMessage;
import de.sarocesch.sarosmoneymod.network.NetworkHandler;
import de.sarocesch.sarosmoneymod.world.inventory.ATMGUIMenu;
import java.util.HashMap;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;

public class ATMGUIScreen
extends AbstractContainerScreen<ATMGUIMenu> {
    private static final HashMap<String, Object> guistate = ATMGUIMenu.guistate;
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    private EditBox withdraw;
    private Button button_payout;
    private Button button_deposit;
    private int lastButtonClickTick;
    private static final int UPDATE_DELAY_TICKS = 5;
    private int tickCounter;
    private int glowTimer = 0;
    private double prevBalance = -1.0;
    private static final ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"saros__money_mod", (String)"textures/screens/atmgui.png");

    public ATMGUIScreen(ATMGUIMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 176;
        this.imageHeight = 166;
        this.tickCounter = 0;
        this.lastButtonClickTick = -1;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.withdraw.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int gx, int gy) {
        guiGraphics.blit(RenderType::guiTextured, texture, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        if (this.withdraw.isFocused()) {
            return this.withdraw.keyPressed(key, b, c);
        }
        return super.keyPressed(key, b, c);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        double balance = ((ATMGUIMenu)this.menu).getBalance();
        String balanceText = "Balance: " + String.format("%.2f", balance);
        int normalColor = -12829636;
        if (this.glowTimer > 0) {
            float progress = (float)this.glowTimer / 20.0f;
            int alpha = (int)(progress * 255.0f);
            int glowColor = alpha << 24 | 0xFFFFFF;
            for (int offsetX = -1; offsetX <= 1; ++offsetX) {
                for (int offsetY = -1; offsetY <= 1; ++offsetY) {
                    if (offsetX == 0 && offsetY == 0) continue;
                    guiGraphics.drawString(this.font, balanceText, 3 + offsetX, 16 + offsetY, glowColor, false);
                }
            }
        }
        guiGraphics.drawString(this.font, balanceText, 3, 16, normalColor, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"ATM"), 3, 4, normalColor, false);
    }

    public void containerTick() {
        double currentBalance;
        super.containerTick();
        ++this.tickCounter;
        if (this.lastButtonClickTick != -1 && this.tickCounter - this.lastButtonClickTick >= 5) {
            this.lastButtonClickTick = -1;
        }
        if (Math.abs((currentBalance = ((ATMGUIMenu)this.menu).getBalance()) - this.prevBalance) > 0.001) {
            this.glowTimer = 20;
            this.prevBalance = currentBalance;
        }
        if (this.glowTimer > 0) {
            --this.glowTimer;
        }
    }

    public void onClose() {
        super.onClose();
    }

    public void init() {
        super.init();
        this.withdraw = new EditBox(this.font, this.leftPos + 6, this.topPos + 39, 54, 20, (Component)Component.translatable((String)"gui.saros__money_mod.atmgui.withdraw"));
        this.withdraw.setMaxLength(Short.MAX_VALUE);
        guistate.put("text:withdraw", this.withdraw);
        this.addWidget((GuiEventListener)this.withdraw);
        this.button_payout = Button.builder((Component)Component.translatable((String)"gui.saros__money_mod.atmgui.button_payout"), e -> {
            String value = this.withdraw.getValue();
            NetworkHandler.sendToServer(new ATMGUIButtonMessage(0, BlockPos.ZERO, value));
            this.withdraw.setValue("");
            this.lastButtonClickTick = this.tickCounter;
        }).pos(this.leftPos + 112, this.topPos + 39).size(56, 20).build();
        guistate.put("button:button_payout", this.button_payout);
        this.addRenderableWidget((GuiEventListener)this.button_payout);
        this.withdraw.setValue("");
        this.button_deposit = Button.builder((Component)Component.translatable((String)"gui.saros__money_mod.atmgui.button_deposit"), e -> {
            String value = this.withdraw.getValue();
            NetworkHandler.sendToServer(new ATMGUIButtonMessage(1, BlockPos.ZERO, value));
            this.withdraw.setValue("");
            this.lastButtonClickTick = this.tickCounter;
        }).pos(this.leftPos + 112, this.topPos + 62).size(56, 20).build();
        guistate.put("button:button_deposit", this.button_deposit);
        this.addRenderableWidget((GuiEventListener)this.button_deposit);
    }
}

