/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import de.sarocesch.sarosmoneymod.data.BalanceManager;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class LeaderboardCommand {
    private static LeaderboardData leaderboardData;

    @SubscribeEvent
    public static void registerCommand(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"leaderboard").then(Commands.literal((String)"create").then(Commands.argument((String)"number", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> LeaderboardCommand.createLeaderboard((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"number")))))).then(Commands.literal((String)"delete").executes(LeaderboardCommand::deleteLeaderboards)));
    }

    private static int createLeaderboard(CommandContext<CommandSourceStack> context, int number) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            ServerPlayer player = source.getPlayerOrException();
            ServerLevel world = player.serverLevel();
            if (leaderboardData == null) {
                leaderboardData = LeaderboardData.load(world);
            }
            BlockPos position = player.blockPosition();
            Leaderboard newLeaderboard = new Leaderboard(position, number);
            leaderboardData.addLeaderboard(newLeaderboard);
            LeaderboardCommand.updateLeaderboard((Level)world, newLeaderboard);
            leaderboardData.setDirty();
            source.sendSuccess(() -> Component.literal((String)"\u00a7aLeaderboard created successfully."), true);
        }
        catch (CommandSyntaxException e) {
            source.sendFailure((Component)Component.literal((String)"\u00a7cFailed to create leaderboard."));
            e.printStackTrace();
        }
        return 1;
    }

    private static int deleteLeaderboards(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            ServerPlayer player = source.getPlayerOrException();
            ServerLevel world = player.serverLevel();
            if (leaderboardData == null) {
                leaderboardData = LeaderboardData.load(world);
            }
            BlockPos playerPos = player.blockPosition();
            int radius = 5;
            List toRemove = leaderboardData.getLeaderboards().stream().filter(lb -> lb.getPosition().closerThan((Vec3i)playerPos, (double)radius)).collect(Collectors.toList());
            for (Leaderboard leaderboard : toRemove) {
                leaderboard.getArmorStands().forEach(armorStand -> {
                    if (armorStand != null && !armorStand.isRemoved()) {
                        armorStand.kill(world);
                    }
                });
                leaderboardData.removeLeaderboard(leaderboard);
            }
            leaderboardData.setDirty();
            source.sendSuccess(() -> Component.literal((String)"\u00a7aLeaderboards deleted successfully."), true);
        }
        catch (CommandSyntaxException e) {
            source.sendFailure((Component)Component.literal((String)"\u00a7cFailed to delete leaderboards."));
            e.printStackTrace();
        }
        return 1;
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        ServerLevel world;
        TickEvent.Phase phase = event.phase;
        if (phase == TickEvent.Phase.END && event.getServer() != null && (world = event.getServer().getLevel(Level.OVERWORLD)) != null) {
            if (leaderboardData == null) {
                leaderboardData = LeaderboardData.load(world);
            }
            for (Leaderboard leaderboard : leaderboardData.getLeaderboards()) {
                LeaderboardCommand.updateLeaderboard((Level)world, leaderboard);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent event) {
        if (event.getEntity() instanceof ArmorStand && event.getLevel() instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)event.getLevel();
            if (leaderboardData == null) {
                leaderboardData = LeaderboardData.load(world);
            }
            ArmorStand armorStand = (ArmorStand)event.getEntity();
            BlockPos armorStandPos = armorStand.blockPosition();
            leaderboardData.getLeaderboards().forEach(leaderboard -> {
                if (leaderboard.getPosition().equals((Object)armorStandPos)) {
                    leaderboard.addArmorStand(armorStand);
                }
            });
        }
    }

    private static void updateLeaderboard(Level world, Leaderboard leaderboard) {
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverWorld = (ServerLevel)world;
        Map<String, Double> balances = BalanceManager.loadBalances(world.getServer());
        List sortedBalances = balances.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).limit(leaderboard.getSize()).collect(Collectors.toList());
        ArrayList<CallSite> leaderboardLines = new ArrayList<CallSite>();
        int i = 1;
        for (Map.Entry entry : sortedBalances) {
            try {
                UUID playerUUID = UUID.fromString((String)entry.getKey());
                Optional profile = world.getServer().getProfileCache().get(playerUUID);
                String playerName = profile.map(GameProfile::getName).orElse("Unknown Player");
                leaderboardLines.add((CallSite)((Object)(i + ". " + playerName + ": " + String.format("%.2f", entry.getValue()))));
                ++i;
            }
            catch (IllegalArgumentException e) {
                System.err.println("Invalid UUID string: " + (String)entry.getKey());
            }
        }
        leaderboard.getArmorStands().forEach(armorStand -> {
            if (armorStand != null && !armorStand.isRemoved()) {
                armorStand.kill(serverWorld);
            }
        });
        leaderboard.clearArmorStands();
        BlockPos position = leaderboard.getPosition();
        for (int j = 0; j < leaderboardLines.size(); ++j) {
            String line = (String)leaderboardLines.get(j);
            ArmorStand armorStand2 = new ArmorStand(world, (double)position.getX(), (double)position.getY() - (double)j * 0.25, (double)position.getZ());
            armorStand2.setInvisible(true);
            armorStand2.setCustomName((Component)Component.literal((String)line));
            armorStand2.setCustomNameVisible(true);
            armorStand2.setNoGravity(true);
            world.addFreshEntity((Entity)armorStand2);
            leaderboard.addArmorStand(armorStand2);
        }
    }

    private static class LeaderboardData
    extends SavedData {
        private static final String DATA_NAME = "leaderboard_data";
        private final List<Leaderboard> leaderboards = new ArrayList<Leaderboard>();
        public static final Codec<LeaderboardData> CODEC = Codec.unit(LeaderboardData::new).xmap(d -> d, d -> d);

        public List<Leaderboard> getLeaderboards() {
            return this.leaderboards;
        }

        public void addLeaderboard(Leaderboard leaderboard) {
            this.leaderboards.add(leaderboard);
            this.setDirty();
        }

        public void removeLeaderboard(Leaderboard leaderboard) {
            this.leaderboards.remove(leaderboard);
            this.setDirty();
        }

        public CompoundTag save(CompoundTag compound, HolderLookup.Provider provider) {
            ListTag tags = new ListTag();
            this.leaderboards.stream().map(Leaderboard::saveToTag).forEach(arg_0 -> tags.add(arg_0));
            compound.put("leaderboards", (Tag)tags);
            return compound;
        }

        public static LeaderboardData load(CompoundTag tag, HolderLookup.Provider provider) {
            LeaderboardData data = new LeaderboardData();
            if (tag.contains("leaderboards")) {
                ListTag tags = tag.getList("leaderboards").orElse(new ListTag());
                for (int i = 0; i < tags.size(); ++i) {
                    Tag tag2 = tags.get(i);
                    if (!(tag2 instanceof CompoundTag)) continue;
                    CompoundTag compoundTag = (CompoundTag)tag2;
                    data.addLeaderboard(Leaderboard.fromTag(compoundTag));
                }
            }
            return data;
        }

        public static LeaderboardData load(ServerLevel world) {
            return (LeaderboardData)world.getDataStorage().computeIfAbsent(new SavedDataType(DATA_NAME, () -> new LeaderboardData(), CODEC, null));
        }
    }

    private static class Leaderboard {
        private final BlockPos position;
        private final int size;
        private final List<ArmorStand> armorStands;

        public Leaderboard(BlockPos position, int size) {
            this.position = position;
            this.size = size;
            this.armorStands = new ArrayList<ArmorStand>();
        }

        public BlockPos getPosition() {
            return this.position;
        }

        public int getSize() {
            return this.size;
        }

        public List<ArmorStand> getArmorStands() {
            return this.armorStands;
        }

        public void addArmorStand(ArmorStand armorStand) {
            this.armorStands.add(armorStand);
        }

        public void clearArmorStands() {
            this.armorStands.clear();
        }

        public CompoundTag saveToTag() {
            CompoundTag tag = new CompoundTag();
            tag.putInt("x", this.position.getX());
            tag.putInt("y", this.position.getY());
            tag.putInt("z", this.position.getZ());
            tag.putInt("size", this.size);
            return tag;
        }

        public static Leaderboard fromTag(CompoundTag tag) {
            BlockPos pos = new BlockPos(tag.getInt("x").orElse(0).intValue(), tag.getInt("y").orElse(0).intValue(), tag.getInt("z").orElse(0).intValue());
            int size = tag.getInt("size").orElse(5);
            return new Leaderboard(pos, size);
        }
    }
}

