/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.data;

import de.sarocesch.sarosmoneymod.SarosMoneyMod;
import java.lang.reflect.Method;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="saros__money_mod")
public class SignAttachmentType {
    private static final String SIGN_DATA_KEY = "SignData";
    public static final SignData SIGN_DATA = new SignData();

    public static SignData getData(SignBlockEntity sign) {
        RegistryAccess registryAccess = sign.getLevel().registryAccess();
        CompoundTag blockEntityTag = sign.saveWithoutMetadata((HolderLookup.Provider)registryAccess);
        if (blockEntityTag.contains(SIGN_DATA_KEY)) {
            SignData data = new SignData();
            CompoundTag signDataTag = blockEntityTag.getCompound(SIGN_DATA_KEY).orElse(new CompoundTag());
            data.deserializeFromNBT(signDataTag);
            return data;
        }
        return new SignData();
    }

    public static void setData(SignBlockEntity sign, SignData data) {
        RegistryAccess registryAccess = sign.getLevel().registryAccess();
        CompoundTag blockEntityTag = sign.saveWithoutMetadata((HolderLookup.Provider)registryAccess);
        CompoundTag signDataTag = new CompoundTag();
        data.serializeToNBT(signDataTag);
        blockEntityTag.put(SIGN_DATA_KEY, (Tag)signDataTag);
        try {
            Method method = SignBlockEntity.class.getMethod("load", CompoundTag.class, RegistryAccess.class);
            method.invoke((Object)sign, blockEntityTag, registryAccess);
        }
        catch (Exception e) {
            SarosMoneyMod.LOGGER.error("Fehler beim Laden der SignData: " + e.getMessage());
        }
        sign.setChanged();
    }

    public static class SignData {
        private UUID ownerUUID;
        private String shopType = "";
        private String itemId = "";
        private int price = 0;
        private int amount = 0;

        public UUID getOwnerUUID() {
            return this.ownerUUID;
        }

        public void setOwnerUUID(UUID ownerUUID) {
            this.ownerUUID = ownerUUID;
        }

        public String getShopType() {
            return this.shopType;
        }

        public void setShopType(String shopType) {
            this.shopType = shopType;
        }

        public String getItemId() {
            return this.itemId;
        }

        public void setItemId(String itemId) {
            this.itemId = itemId;
        }

        public int getPrice() {
            return this.price;
        }

        public void setPrice(int price) {
            this.price = price;
        }

        public int getAmount() {
            return this.amount;
        }

        public void setAmount(int amount) {
            this.amount = amount;
        }

        public void serializeToNBT(CompoundTag tag) {
            if (this.ownerUUID != null) {
                tag.putString("OwnerUUID", this.ownerUUID.toString());
            }
            tag.putString("ShopType", this.shopType);
            tag.putString("ItemId", this.itemId);
            tag.putInt("Price", this.price);
            tag.putInt("Amount", this.amount);
        }

        public void deserializeFromNBT(CompoundTag tag) {
            String uuidString;
            if (tag.contains("OwnerUUID") && !(uuidString = tag.getString("OwnerUUID").orElse("")).isEmpty()) {
                try {
                    this.ownerUUID = UUID.fromString(uuidString);
                }
                catch (IllegalArgumentException e) {
                    SarosMoneyMod.LOGGER.error("Fehler beim Parsen der UUID: " + e.getMessage());
                }
            }
            this.shopType = tag.getString("ShopType").orElse("");
            this.itemId = tag.getString("ItemId").orElse("");
            this.price = tag.getInt("Price").orElse(0);
            this.amount = tag.getInt("Amount").orElse(0);
        }
    }
}

