/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.handlers;

import de.sarocesch.sarosmoneymod.data.BalanceManager;
import de.sarocesch.sarosmoneymod.handlers.ContainerHandler;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ShopSignHandler {
    private static String stripFormatting(String text) {
        return text.replaceAll("\u00a7[0-9a-fk-or]", "").trim();
    }

    public static void handleSignInteraction(UUID ownerUUID, Player customer, String itemName, double price, String type, BlockPos signPos) {
        if (!(customer instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverCustomer = (ServerPlayer)customer;
        Level level = customer.level();
        BlockState signState = level.getBlockState(signPos);
        BlockPos containerPos = ContainerHandler.getAttachedContainerPos(level, signPos, signState);
        BlockEntity blockEntity = level.getBlockEntity(containerPos);
        if (!(blockEntity instanceof Container)) {
            ((ServerPlayer)customer).sendSystemMessage((Component)Component.translatable((String)"shop.error.no_container").withStyle(ChatFormatting.RED));
            return;
        }
        Container container = (Container)blockEntity;
        if (blockEntity instanceof ChestBlockEntity) {
            ChestBlockEntity chest = (ChestBlockEntity)blockEntity;
            chest.setChanged();
        }
        if (type.equalsIgnoreCase("buy")) {
            ShopSignHandler.handleBuyInteraction(ownerUUID, serverCustomer, itemName, price, container);
        } else if (type.equalsIgnoreCase("sell")) {
            ShopSignHandler.handleSellInteraction(ownerUUID, serverCustomer, itemName, price, container);
        }
        serverCustomer.inventoryMenu.broadcastChanges();
        serverCustomer.containerMenu.sendAllDataToRemote();
    }

    private static void handleBuyInteraction(UUID ownerUUID, ServerPlayer customer, String itemName, double price, Container container) {
        double customerBalance = BalanceManager.getPlayerBalance(customer);
        if (customerBalance < price) {
            customer.sendSystemMessage((Component)Component.translatable((String)"shop.error.not_enough_money", (Object[])new Object[]{String.format("%.2f", price)}).withStyle(ChatFormatting.RED));
            return;
        }
        ItemStack itemToTransfer = null;
        int containerSlot = -1;
        for (int i = 0; i < container.getContainerSize(); ++i) {
            ItemStack stack = container.getItem(i);
            if (stack.isEmpty() || !ShopSignHandler.matchesItemName(stack, itemName)) continue;
            itemToTransfer = stack.copy();
            containerSlot = i;
            break;
        }
        if (itemToTransfer == null) {
            customer.sendSystemMessage((Component)Component.translatable((String)"shop.error.item_not_available").withStyle(ChatFormatting.RED));
            return;
        }
        ItemStack singleItem = itemToTransfer.copy();
        singleItem.setCount(1);
        if (!ShopSignHandler.hasInventorySpace(customer.getInventory(), singleItem)) {
            customer.sendSystemMessage((Component)Component.translatable((String)"shop.error.inventory_full").withStyle(ChatFormatting.RED));
            return;
        }
        BalanceManager.updatePlayerBalance(customer, customerBalance - price);
        ShopSignHandler.addBalance(ownerUUID.toString(), price);
        container.removeItem(containerSlot, 1);
        ShopSignHandler.addToInventory(customer, singleItem.copy());
        ShopSignHandler.sendNotifications(customer, ownerUUID, itemName, price, "buy");
    }

    private static void handleSellInteraction(UUID ownerUUID, ServerPlayer customer, String itemName, double price, Container container) {
        String ownerUUIDString = ownerUUID.toString();
        double ownerBalance = BalanceManager.getBalance(ownerUUIDString);
        if (ownerBalance < price) {
            customer.sendSystemMessage((Component)Component.translatable((String)"shop.error.owner_not_enough_money").withStyle(ChatFormatting.RED));
            return;
        }
        ItemStack itemToSell = null;
        int inventorySlot = -1;
        Inventory inventory = customer.getInventory();
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (stack.isEmpty() || !ShopSignHandler.matchesItemName(stack, itemName)) continue;
            itemToSell = stack.copy();
            inventorySlot = i;
            break;
        }
        if (itemToSell == null) {
            customer.sendSystemMessage((Component)Component.translatable((String)"shop.error.item_not_in_inventory").withStyle(ChatFormatting.RED));
            return;
        }
        if (!ShopSignHandler.hasContainerSpace(container, itemToSell)) {
            customer.sendSystemMessage((Component)Component.translatable((String)"shop.error.container_full").withStyle(ChatFormatting.RED));
            return;
        }
        ShopSignHandler.addBalance(customer.getUUID().toString(), price);
        BalanceManager.setBalance(ownerUUIDString, ownerBalance - price);
        inventory.removeItem(inventorySlot, 1);
        ShopSignHandler.addToContainer(container, itemToSell.copy());
        ShopSignHandler.sendNotifications(customer, ownerUUID, itemName, price, "sell");
    }

    private static boolean matchesItemName(ItemStack stack, String searchName) {
        String stackName = ShopSignHandler.stripFormatting(stack.getHoverName().getString());
        return stackName.equalsIgnoreCase(ShopSignHandler.stripFormatting(searchName));
    }

    private static void addToInventory(ServerPlayer player, ItemStack itemStack) {
        int i;
        Inventory inventory = player.getInventory();
        for (i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (stack.isEmpty() || !stack.is(itemStack.getItem()) || stack.getCount() >= stack.getMaxStackSize()) continue;
            stack.grow(1);
            inventory.setItem(i, stack);
            return;
        }
        for (i = 0; i < inventory.getContainerSize(); ++i) {
            if (!inventory.getItem(i).isEmpty()) continue;
            inventory.setItem(i, itemStack);
            return;
        }
    }

    private static void sendNotifications(ServerPlayer customer, UUID ownerUUID, String itemName, double price, String type) {
        if (type.equals("buy")) {
            customer.sendSystemMessage((Component)Component.translatable((String)"shop.buy.success", (Object[])new Object[]{itemName, String.format("%.2f", price)}).withStyle(Style.EMPTY.withColor(ChatFormatting.GREEN)));
            ServerPlayer owner = customer.getServer().getPlayerList().getPlayer(ownerUUID);
            if (owner != null) {
                owner.sendSystemMessage((Component)Component.translatable((String)"shop.buy.owner_notification", (Object[])new Object[]{customer.getDisplayName().getString(), itemName, String.format("%.2f", price)}).withStyle(Style.EMPTY.withColor(ChatFormatting.GREEN)));
            }
        } else {
            customer.sendSystemMessage((Component)Component.translatable((String)"shop.sell.success", (Object[])new Object[]{itemName, String.format("%.2f", price)}).withStyle(Style.EMPTY.withColor(ChatFormatting.GREEN)));
            ServerPlayer owner = customer.getServer().getPlayerList().getPlayer(ownerUUID);
            if (owner != null) {
                owner.sendSystemMessage((Component)Component.translatable((String)"shop.sell.owner_notification", (Object[])new Object[]{customer.getDisplayName().getString(), itemName, String.format("%.2f", price)}).withStyle(Style.EMPTY.withColor(ChatFormatting.GREEN)));
            }
        }
    }

    private static void addBalance(String playerUUID, double amount) {
        double current = BalanceManager.getBalance(playerUUID);
        BalanceManager.setBalance(playerUUID, current + amount);
    }

    private static boolean hasInventorySpace(Inventory inventory, ItemStack itemStack) {
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (stack.isEmpty()) {
                return true;
            }
            if (!stack.is(itemStack.getItem()) || stack.getCount() >= stack.getMaxStackSize()) continue;
            return true;
        }
        return false;
    }

    private static boolean hasContainerSpace(Container container, ItemStack itemStack) {
        for (int i = 0; i < container.getContainerSize(); ++i) {
            ItemStack stack = container.getItem(i);
            if (stack.isEmpty()) {
                return true;
            }
            if (!stack.is(itemStack.getItem()) || stack.getCount() >= stack.getMaxStackSize()) continue;
            return true;
        }
        return false;
    }

    private static void addToContainer(Container container, ItemStack itemStack) {
        int i;
        for (i = 0; i < container.getContainerSize(); ++i) {
            ItemStack stack = container.getItem(i);
            if (stack.isEmpty() || !stack.is(itemStack.getItem()) || stack.getCount() >= stack.getMaxStackSize()) continue;
            stack.grow(1);
            container.setItem(i, stack);
            return;
        }
        for (i = 0; i < container.getContainerSize(); ++i) {
            if (!container.getItem(i).isEmpty()) continue;
            container.setItem(i, itemStack);
            return;
        }
    }
}

