/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.listener;

import de.sarocesch.sarosmoneymod.block.ATM2Block;
import de.sarocesch.sarosmoneymod.block.ATM3Block;
import de.sarocesch.sarosmoneymod.block.ATMBlock;
import de.sarocesch.sarosmoneymod.world.inventory.ATMGUIMenu;
import io.netty.buffer.Unpooled;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ATMInteractionListener {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos;
        Player player = event.getEntity();
        Level level = event.getLevel();
        BlockState state = level.getBlockState(pos = event.getPos());
        if (state.getBlock() instanceof ATMBlock || state.getBlock() instanceof ATM2Block || state.getBlock() instanceof ATM3Block) {
            event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
            event.setCanceled(true);
            if (!level.isClientSide() && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.openMenu(new MenuProvider(){

                    public Component getDisplayName() {
                        return Component.literal((String)"ATM");
                    }

                    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                        return new ATMGUIMenu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).writeBlockPos(pos));
                    }
                });
            }
        }
    }
}

