/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.listener;

import de.sarocesch.sarosmoneymod.SarosMoneyMod;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractSignEditScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

@Mod.EventBusSubscriber(modid="saros__money_mod", value={Dist.CLIENT})
public class SignShopClientListener {
    private static Field signField;

    private static void initSignField() {
        try {
            signField = ObfuscationReflectionHelper.findField(AbstractSignEditScreen.class, (String)"sign");
            signField.setAccessible(true);
        }
        catch (Exception e) {
            SarosMoneyMod.LOGGER.error("Failed to find sign field:", (Throwable)e);
        }
    }

    @SubscribeEvent
    public static void onScreenInit(ScreenEvent.Init event) {
        if (event.getScreen() instanceof AbstractSignEditScreen && signField == null) {
            SignShopClientListener.initSignField();
        }
    }

    @SubscribeEvent
    public static void onScreenClose(ScreenEvent.Closing event) {
        Screen screen = event.getScreen();
        if (screen instanceof AbstractSignEditScreen) {
            AbstractSignEditScreen screen2 = (AbstractSignEditScreen)screen;
            try {
                SignBlockEntity sign;
                if (signField == null) {
                    SignShopClientListener.initSignField();
                }
                if ((sign = (SignBlockEntity)signField.get(screen2)) != null) {
                    boolean isShop;
                    BlockPos pos = sign.getBlockPos();
                    SignText signText = sign.getText(true);
                    Component[] messages = signText.getMessages(true);
                    String firstLine = messages[0].getString().trim().toLowerCase();
                    boolean bl = isShop = firstLine.contains("shop") || firstLine.contains("buy") || firstLine.contains("sell");
                    if (isShop) {
                        SarosMoneyMod.LOGGER.debug("Detected shop sign creation, sending to server");
                    }
                    sign.setChanged();
                    Level level = sign.getLevel();
                    if (level != null) {
                        level.sendBlockUpdated(sign.getBlockPos(), level.getBlockState(sign.getBlockPos()), level.getBlockState(sign.getBlockPos()), 3);
                    }
                    SarosMoneyMod.LOGGER.info("Sign updated at " + String.valueOf(sign.getBlockPos()));
                }
            }
            catch (Exception e) {
                SarosMoneyMod.LOGGER.error("Error processing sign edit screen closing:", (Throwable)e);
            }
        }
    }

    @SubscribeEvent
    public static void onSignClose(ScreenEvent.Closing event) {
        Screen screen = event.getScreen();
        if (screen instanceof AbstractSignEditScreen) {
            AbstractSignEditScreen screen2 = (AbstractSignEditScreen)screen;
            Minecraft.getInstance().execute(() -> {
                try {
                    if (signField == null) {
                        SignShopClientListener.initSignField();
                    }
                    SignBlockEntity sign = (SignBlockEntity)signField.get(screen2);
                    sign.setChanged();
                    Level level = sign.getLevel();
                    if (level != null) {
                        level.sendBlockUpdated(sign.getBlockPos(), level.getBlockState(sign.getBlockPos()), level.getBlockState(sign.getBlockPos()), 3);
                    }
                    SarosMoneyMod.LOGGER.info("Sign updated at " + String.valueOf(sign.getBlockPos()));
                }
                catch (Exception e) {
                    SarosMoneyMod.LOGGER.error("Sign update failed", (Throwable)e);
                }
            });
        }
    }
}

