/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.data;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class BalanceData
extends SavedData {
    private static final String DATA_NAME = "sarosmoneymod_balance";
    private final Map<String, Double> balances = new HashMap<String, Double>();

    public static SavedData.Factory<BalanceData> factory() {
        return new SavedData.Factory(() -> new BalanceData(), (tag, provider) -> BalanceData.load(tag, provider), null);
    }

    public static BalanceData load(CompoundTag compound, HolderLookup.Provider provider) {
        BalanceData data = new BalanceData();
        if (compound.contains("balances", 10)) {
            CompoundTag mapTag = compound.getCompound("balances");
            for (String key : mapTag.getAllKeys()) {
                if (mapTag.contains(key, 6)) {
                    data.balances.put(key, mapTag.getDouble(key));
                    continue;
                }
                data.balances.put(key, Double.valueOf(mapTag.getInt(key)));
            }
        }
        return data;
    }

    public CompoundTag save(CompoundTag p_77763_, HolderLookup.Provider p_334349_) {
        CompoundTag mapTag = new CompoundTag();
        for (Map.Entry<String, Double> entry : this.balances.entrySet()) {
            mapTag.putDouble(entry.getKey(), entry.getValue().doubleValue());
        }
        p_77763_.put("balances", (Tag)mapTag);
        return p_77763_;
    }

    public double getBalance(String playerUUID) {
        return this.balances.getOrDefault(playerUUID, 0.0);
    }

    public boolean containsBalance(String playerUUID) {
        return this.balances.containsKey(playerUUID);
    }

    public void setBalance(String playerUUID, double balance) {
        this.balances.put(playerUUID, balance);
        this.setDirty();
    }

    public Map<String, Double> getAllBalances() {
        return new HashMap<String, Double>(this.balances);
    }

    public static BalanceData get(MinecraftServer server) {
        if (server == null) {
            throw new IllegalArgumentException("Server instance is null");
        }
        ServerLevel level = server.overworld();
        return (BalanceData)level.getDataStorage().computeIfAbsent(BalanceData.factory(), DATA_NAME);
    }
}

