/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.item;

import de.sarocesch.sarosmoneymod.SarosMoneyMod;
import de.sarocesch.sarosmoneymod.world.inventory.WalletGUIMenu;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.ItemStackHandler;

public class WalletItem
extends Item {
    public WalletItem(Item.Properties properties) {
        super(properties);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag compound) {
        if (!stack.has(DataComponents.CUSTOM_DATA)) {
            CompoundTag nbt = new CompoundTag();
            nbt.put("Inventory", (Tag)new CompoundTag());
            stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)nbt));
        }
        return null;
    }

    public InteractionResult use(Level world, final Player entity, InteractionHand hand) {
        ItemStack itemstack = entity.getItemInHand(hand);
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        if (!world.isClientSide()) {
            this.initInventoryData(itemstack);
            entity.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return Component.literal((String)"Wallet");
                }

                public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                    FriendlyByteBuf packetBuffer = new FriendlyByteBuf(Unpooled.buffer());
                    packetBuffer.writeBlockPos(entity.blockPosition());
                    packetBuffer.writeInt(0);
                    return new WalletGUIMenu(id, inventory, packetBuffer);
                }
            });
        }
        return InteractionResult.SUCCESS;
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(stack, world, entity, slot, selected);
        if (!world.isClientSide()) {
            this.initInventoryData(stack);
        }
    }

    private void initInventoryData(ItemStack stack) {
        if (!stack.has(DataComponents.CUSTOM_DATA)) {
            CompoundTag nbt = new CompoundTag();
            nbt.put("Inventory", (Tag)new CompoundTag());
            stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)nbt));
        }
    }

    private void saveInventoryToData(ItemStack stack) {
        try {
            CompoundTag itemsTag;
            Method method;
            CompoundTag inventoryTag;
            ItemStackHandler handler;
            CompoundTag nbt;
            block9: {
                SarosMoneyMod.LOGGER.info("Saving inventory data to wallet: " + stack.getItem().getClass().getSimpleName());
                nbt = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
                SarosMoneyMod.LOGGER.info("Current custom data: " + String.valueOf(nbt));
                handler = new ItemStackHandler(18);
                if (nbt.contains("Inventory")) {
                    inventoryTag = nbt.getCompound("Inventory");
                    try {
                        method = handler.getClass().getMethod("deserializeNBT", CompoundTag.class);
                        method.invoke((Object)handler, inventoryTag);
                    }
                    catch (Exception e) {
                        if (!inventoryTag.contains("Items")) break block9;
                        itemsTag = inventoryTag.getCompound("Items");
                        for (String key : itemsTag.getAllKeys()) {
                            if (!key.startsWith("slot_")) continue;
                            int slotIndex = Integer.parseInt(key.substring(5));
                            CompoundTag compoundTag = itemsTag.getCompound(key);
                        }
                    }
                }
            }
            try {
                method = handler.getClass().getMethod("serializeNBT", new Class[0]);
                inventoryTag = (CompoundTag)method.invoke((Object)handler, new Object[0]);
            }
            catch (Exception e) {
                inventoryTag = new CompoundTag();
                itemsTag = new CompoundTag();
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack slotStack = handler.getStackInSlot(i);
                    if (slotStack.isEmpty()) continue;
                    CompoundTag itemTag = new CompoundTag();
                    slotStack.save((HolderLookup.Provider)itemTag);
                    itemsTag.put("slot_" + i, (Tag)itemTag);
                }
                inventoryTag.put("Items", (Tag)itemsTag);
            }
            nbt.put("Inventory", (Tag)inventoryTag);
            SarosMoneyMod.LOGGER.info("Updated custom data: " + String.valueOf(nbt));
            CustomData newCustomData = CustomData.of((CompoundTag)nbt);
            stack.set(DataComponents.CUSTOM_DATA, (Object)newCustomData);
            SarosMoneyMod.LOGGER.info("CustomData gesetzt: " + String.valueOf(newCustomData));
        }
        catch (Exception e) {
            SarosMoneyMod.LOGGER.error("Fehler beim Speichern des Inventars: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void loadInventoryFromData(ItemStack stack) {
        block7: {
            try {
                CompoundTag nbt;
                CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
                if (customData == null || !(nbt = customData.copyTag()).contains("Inventory")) break block7;
                CompoundTag inventoryTag = nbt.getCompound("Inventory");
                ItemStackHandler handler = new ItemStackHandler(18);
                for (int i = 0; i < handler.getSlots(); ++i) {
                    handler.setStackInSlot(i, ItemStack.EMPTY);
                }
                try {
                    Method method = handler.getClass().getMethod("deserializeNBT", CompoundTag.class);
                    method.invoke((Object)handler, inventoryTag);
                }
                catch (Exception e) {
                    if (inventoryTag.contains("Items")) {
                        CompoundTag itemsTag = inventoryTag.getCompound("Items");
                        for (String key : itemsTag.getAllKeys()) {
                            if (!key.startsWith("slot_")) continue;
                            int slotIndex = Integer.parseInt(key.substring(5));
                            CompoundTag compoundTag = itemsTag.getCompound(key);
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

