/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.listener;

import de.sarocesch.sarosmoneymod.SarosMoneyMod;
import de.sarocesch.sarosmoneymod.data.SignAttachmentType;
import de.sarocesch.sarosmoneymod.handlers.ServerHandler;
import de.sarocesch.sarosmoneymod.handlers.ShopSignHandler;
import java.lang.reflect.Field;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="saros__money_mod")
public class SignShopListener {
    @SubscribeEvent
    public static void onSignPlaced(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            BlockPos signPos;
            Player player = (Player)entity;
            Level level = (Level)event.getLevel();
            BlockEntity blockEntity = level.getBlockEntity(signPos = event.getPos());
            if (blockEntity instanceof SignBlockEntity) {
                SignBlockEntity sign = (SignBlockEntity)blockEntity;
                SignAttachmentType.SignData data = SignAttachmentType.getData(sign);
                data.setOwnerUUID(player.getUUID());
                BlockState signState = level.getBlockState(signPos);
                Direction facing = Direction.NORTH;
                if (signState.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                    facing = (Direction)signState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                } else if (signState.hasProperty((Property)BlockStateProperties.ROTATION_16)) {
                    int rotation = (Integer)signState.getValue((Property)BlockStateProperties.ROTATION_16);
                    facing = Direction.from2DDataValue((int)(rotation / 4));
                }
                BlockPos containerPos = signPos.relative(facing.getOpposite());
                try {
                    Field persistentDataField = SignBlockEntity.class.getDeclaredField("persistentData");
                    persistentDataField.setAccessible(true);
                    CompoundTag nbt = (CompoundTag)persistentDataField.get(sign);
                    nbt.putIntArray("ContainerPos", new int[]{containerPos.getX(), containerPos.getY(), containerPos.getZ()});
                }
                catch (Exception e) {
                    SarosMoneyMod.LOGGER.error("Failed to set container position in sign NBT", (Throwable)e);
                }
                sign.setChanged();
                if (!level.isClientSide() && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ServerHandler.handleSignUpdate(serverPlayer, signPos);
                    if (level.getServer() != null) {
                        level.getServer().execute(() -> ServerHandler.handleSignUpdate(serverPlayer, signPos));
                        level.getServer().execute(() -> ServerHandler.handleSignUpdate(serverPlayer, signPos));
                        level.getServer().execute(() -> ServerHandler.handleSignUpdate(serverPlayer, signPos));
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        UUID ownerUUID;
        Object data;
        SignBlockEntity sign;
        BlockPos pos;
        Player player = event.getPlayer();
        Level level = player.level();
        if (level.getBlockEntity(pos = event.getPos()) instanceof Container && (sign = SignShopListener.findLinkedSign(level, pos)) != null && ((SignAttachmentType.SignData)(data = SignAttachmentType.getData(sign))).getOwnerUUID() != null) {
            ownerUUID = ((SignAttachmentType.SignData)data).getOwnerUUID();
            if (!player.getUUID().equals(ownerUUID) && !player.isCreative()) {
                event.setCanceled(true);
                player.displayClientMessage((Component)Component.translatable((String)"shop.protection.container_owner_only").withStyle(Style.EMPTY.withColor(ChatFormatting.RED).withBold(Boolean.valueOf(true))), true);
            }
        }
        if ((data = level.getBlockEntity(pos)) instanceof SignBlockEntity && ((SignAttachmentType.SignData)(data = SignAttachmentType.getData(sign = (SignBlockEntity)data))).getOwnerUUID() != null) {
            ownerUUID = ((SignAttachmentType.SignData)data).getOwnerUUID();
            if (!player.getUUID().equals(ownerUUID) && !player.isCreative()) {
                event.setCanceled(true);
                player.displayClientMessage((Component)Component.translatable((String)"shop.protection.sign_owner_only").withStyle(Style.EMPTY.withColor(ChatFormatting.RED).withBold(Boolean.valueOf(true))), true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        SignAttachmentType.SignData data;
        SignBlockEntity sign;
        Player player = event.getEntity();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        if (!level.isClientSide() && level.getBlockEntity(pos) instanceof Container && (sign = SignShopListener.findLinkedSign(level, pos)) != null && (data = SignAttachmentType.getData(sign)).getOwnerUUID() != null) {
            UUID ownerUUID = data.getOwnerUUID();
            if (!player.getUUID().equals(ownerUUID)) {
                event.setCanceled(true);
                player.displayClientMessage((Component)Component.translatable((String)"shop.protection.container_use_owner_only").withStyle(Style.EMPTY.withColor(ChatFormatting.RED).withBold(Boolean.valueOf(true))), true);
                return;
            }
        }
    }

    private static SignBlockEntity findLinkedSign(Level level, BlockPos containerPos) {
        for (BlockPos pos : BlockPos.withinManhattan((BlockPos)containerPos, (int)5, (int)5, (int)5)) {
            int[] coords;
            BlockPos linkedPos;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (!(blockEntity instanceof SignBlockEntity)) continue;
            SignBlockEntity sign = (SignBlockEntity)blockEntity;
            CompoundTag nbt = new CompoundTag();
            try {
                Field persistentDataField = SignBlockEntity.class.getDeclaredField("persistentData");
                persistentDataField.setAccessible(true);
                nbt = (CompoundTag)persistentDataField.get(sign);
            }
            catch (Exception e) {
                continue;
            }
            if (!nbt.contains("ContainerPos") || !(linkedPos = new BlockPos((coords = nbt.getIntArray("ContainerPos"))[0], coords[1], coords[2])).equals((Object)containerPos)) continue;
            return sign;
        }
        return null;
    }

    private static String stripFormatting(Component component) {
        return component.getString().replaceAll("\u00a7[0-9a-fk-or]", "");
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onContainerInteract(PlayerInteractEvent.RightClickBlock event) {
        SignAttachmentType.SignData data;
        SignBlockEntity sign;
        Player player = event.getEntity();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        if (level.isClientSide()) {
            return;
        }
        if (level.getBlockEntity(pos) instanceof Container && (sign = SignShopListener.findLinkedSign(level, pos)) != null && (data = SignAttachmentType.getData(sign)).getOwnerUUID() != null) {
            UUID ownerUUID = data.getOwnerUUID();
            if (!player.getUUID().equals(ownerUUID) && !player.isCreative()) {
                boolean isShopInteraction;
                boolean bl = isShopInteraction = player.getMainHandItem().isEmpty() && SignShopListener.isShopSign(sign.getText(true).getMessages(true)[0].getString());
                if (!isShopInteraction) {
                    event.setCanceled(true);
                    player.displayClientMessage((Component)Component.translatable((String)"shop.protection.container_owner_only").withStyle(Style.EMPTY.withColor(ChatFormatting.RED).withBold(Boolean.valueOf(true))), true);
                }
            }
        }
    }

    private static boolean isShopSign(String firstLine) {
        String line = SignShopListener.stripFormatting((Component)Component.literal((String)firstLine)).trim().toLowerCase();
        return line.contains("[shop]") || line.contains("[buy]") || line.contains("[sell]");
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        BlockPos pos = event.getPos();
        Level level = event.getLevel();
        Player player = event.getEntity();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SignBlockEntity) {
            SignBlockEntity sign = (SignBlockEntity)blockEntity;
            Component[] lines = sign.getText(true).getMessages(true);
            String[] signContent = new String[4];
            for (int i = 0; i < 4; ++i) {
                signContent[i] = SignShopListener.stripFormatting(lines[i]).trim();
            }
            String firstLine = signContent[0].toLowerCase();
            if (!firstLine.matches("\\[?(buy|sell|shop)\\]?")) {
                return;
            }
            event.setCanceled(true);
            SignAttachmentType.SignData data = SignAttachmentType.getData(sign);
            UUID ownerUUID = data.getOwnerUUID();
            try {
                String type = "";
                String itemId = "";
                String priceStr = "";
                if (firstLine.equals("[shop]")) {
                    type = signContent[1].toLowerCase();
                    itemId = signContent[2];
                    priceStr = signContent[3];
                } else {
                    type = firstLine.replaceAll("[\\[\\]]", "").toLowerCase();
                    if (signContent[1].isEmpty()) {
                        itemId = signContent[2];
                        priceStr = signContent[3];
                    } else {
                        itemId = signContent[1];
                        priceStr = signContent[2];
                    }
                }
                if (itemId.isEmpty() || priceStr.isEmpty()) {
                    throw new IllegalArgumentException("Missing item or price");
                }
                double price = Double.parseDouble(priceStr.replaceAll("[^\\d.,]", "").replace(",", "."));
                ResourceLocation itemKey = ResourceLocation.tryParse((String)itemId.toLowerCase());
                if (itemKey == null) {
                    return;
                }
                Item item = (Item)ForgeRegistries.ITEMS.getValue(itemKey);
                if (item == null) {
                    throw new IllegalArgumentException("Invalid item: " + itemId);
                }
                ShopSignHandler.handleSignInteraction(ownerUUID, player, item.getDescriptionId(), price, type, pos);
            }
            catch (Exception e) {
                SarosMoneyMod.LOGGER.error("[Shop Error] Interaction failed: {}", (Object)e.getMessage());
                player.displayClientMessage((Component)Component.literal((String)("Shop Error: " + e.getMessage())).withStyle(ChatFormatting.RED), false);
            }
        }
    }

    @SubscribeEvent
    public static void onSignChanged(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            entity = event.getLevel();
            if (entity instanceof Level) {
                Level level = (Level)entity;
                BlockPos pos = event.getPos();
                level.getServer().execute(() -> {
                    BlockEntity patt0$temp = level.getBlockEntity(pos);
                    if (patt0$temp instanceof SignBlockEntity) {
                        SignBlockEntity sign = (SignBlockEntity)patt0$temp;
                        if (player instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)player;
                            ServerHandler.handleSignUpdate(serverPlayer, pos);
                        }
                    }
                });
            }
        }
    }

    private static void processShopInteraction(SignBlockEntity sign, Player player, BlockPos pos) {
        SignAttachmentType.SignData data = SignAttachmentType.getData(sign);
        UUID ownerUUID = data.getOwnerUUID();
        try {
            SignText signText = sign.getText(true);
            Component[] messages = signText.getMessages(true);
            String[] lines = new String[4];
            for (int i = 0; i < 4; ++i) {
                lines[i] = SignShopListener.stripFormatting(messages[i]).trim();
            }
            String type = null;
            String itemId = null;
            String priceStr = null;
            if (lines[0].equalsIgnoreCase("[shop]")) {
                type = lines[1].toLowerCase();
                itemId = lines[2];
                priceStr = lines[3];
            } else if (lines[0].equalsIgnoreCase("[buy]") || lines[0].equalsIgnoreCase("[sell]")) {
                type = lines[0].substring(1, lines[0].length() - 1).toLowerCase();
                itemId = lines[1];
                priceStr = lines[2];
            } else {
                return;
            }
            double price = Double.parseDouble(priceStr.replaceAll("[^0-9.,]", "").replace(',', '.'));
            Item item = (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.parse((String)itemId.toLowerCase()));
            if (item != null) {
                ShopSignHandler.handleSignInteraction(ownerUUID, player, item.getDescriptionId(), price, type, pos);
            }
        }
        catch (Exception e) {
            player.displayClientMessage((Component)Component.translatable((String)"shop.error.invalid_shop_config").withStyle(Style.EMPTY.withColor(ChatFormatting.RED)), true);
        }
    }

    private static boolean hasShopContentInOtherLines(Component[] lines) {
        for (int i = 1; i < lines.length; ++i) {
            String line = SignShopListener.stripFormatting(lines[i]).trim().toLowerCase();
            if (!line.contains("shop") && !line.contains("buy") && !line.contains("sell")) continue;
            return true;
        }
        return false;
    }
}

