/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.network;

import de.sarocesch.sarosmoneymod.handlers.ServerHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SignUpdatePacket {
    private static final Logger LOGGER = LogManager.getLogger();
    private final BlockPos pos;

    public SignUpdatePacket(BlockPos pos) {
        this.pos = pos;
    }

    public SignUpdatePacket(FriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
    }

    public void process(ServerPlayer player) {
        Direction[] directionArray;
        if (player == null) {
            return;
        }
        Level level = player.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.getChunk(this.pos.getX() >> 4, this.pos.getZ() >> 4);
        }
        if ((directionArray = level.getBlockEntity(this.pos)) instanceof SignBlockEntity) {
            SignBlockEntity sign = (SignBlockEntity)directionArray;
            ServerHandler.handleSignUpdate(player, this.pos);
            sign.setChanged();
            level.getChunkAt(this.pos).markUnsaved();
            for (Direction dir : Direction.values()) {
                level.updateNeighborsAt(this.pos.relative(dir), level.getBlockState(this.pos).getBlock());
            }
            if (level.getServer() != null) {
                level.getServer().execute(() -> ServerHandler.handleSignUpdate(player, this.pos));
                level.getServer().execute(() -> {
                    level.sendBlockUpdated(this.pos, level.getBlockState(this.pos), level.getBlockState(this.pos), 3);
                    ServerHandler.handleSignUpdate(player, this.pos);
                });
            }
        }
    }
}

