/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.world.inventory;

import de.sarocesch.sarosmoneymod.SarosMoneyMod;
import de.sarocesch.sarosmoneymod.init.ModMenus;
import de.sarocesch.sarosmoneymod.item.BlackWalletItem;
import de.sarocesch.sarosmoneymod.item.BlueWalletItem;
import de.sarocesch.sarosmoneymod.item.BrownWalletItem;
import de.sarocesch.sarosmoneymod.item.GreenWalletItem;
import de.sarocesch.sarosmoneymod.item.OrangeWalletItem;
import de.sarocesch.sarosmoneymod.item.PurpleWalletItem;
import de.sarocesch.sarosmoneymod.item.WalletItem;
import de.sarocesch.sarosmoneymod.item.YellowWalletItem;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class WalletGUIMenu
extends AbstractContainerMenu
implements Supplier<Map<Integer, Slot>> {
    public static final HashMap<String, Object> guistate = new HashMap();
    public final Level world;
    public final Player entity;
    private IItemHandler internal;
    private final Map<Integer, Slot> customSlots;
    private boolean bound;
    private static final TagKey<Item> MONEY_TAG = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"forge:sarosmoney"));

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WalletGUIMenu(int id, Inventory inv, FriendlyByteBuf extraData) {
        int si;
        block15: {
            BlockPos pos;
            block16: {
                CompoundTag nbt;
                super((MenuType)ModMenus.WALLET_GUI.get(), id);
                this.customSlots = new HashMap<Integer, Slot>();
                this.bound = false;
                this.entity = inv.player;
                this.world = inv.player.level();
                this.internal = new ItemStackHandler(18);
                pos = null;
                if (extraData == null) break block15;
                pos = extraData.readBlockPos();
                int hand = extraData.readInt();
                if (hand != 0) break block16;
                ItemStack itemstack = hand == 0 ? this.entity.getMainHandItem() : this.entity.getOffhandItem();
                CustomData customData = (CustomData)itemstack.get(DataComponents.CUSTOM_DATA);
                if (customData != null && (nbt = customData.copyTag()).contains("Inventory")) {
                    block14: {
                        CompoundTag inventoryTag = nbt.getCompound("Inventory");
                        this.internal = new ItemStackHandler(18);
                        try {
                            Method method = ((ItemStackHandler)this.internal).getClass().getMethod("deserializeNBT", CompoundTag.class);
                            method.invoke((Object)((ItemStackHandler)this.internal), inventoryTag);
                        }
                        catch (Exception e) {
                            if (!inventoryTag.contains("Items")) break block14;
                            CompoundTag itemsTag = inventoryTag.getCompound("Items");
                            for (String key : itemsTag.getAllKeys()) {
                                if (!key.startsWith("slot_")) continue;
                                int slotIndex = Integer.parseInt(key.substring(5));
                                CompoundTag compoundTag = itemsTag.getCompound(key);
                            }
                        }
                    }
                    this.bound = true;
                    IItemHandler iItemHandler = this.internal;
                    if (iItemHandler instanceof ItemStackHandler) {
                        ItemStackHandler handler = (ItemStackHandler)iItemHandler;
                        SarosMoneyMod.LOGGER.info("Wallet-Inventar geladen");
                    }
                }
                break block15;
            }
            if (extraData.readableBytes() > 1) {
                extraData.readByte();
                Entity entity = this.world.getEntity(extraData.readVarInt());
                if (entity == null) {
                    // empty if block
                }
            } else {
                BlockEntity ent;
                BlockEntity blockEntity = ent = inv.player != null ? inv.player.level().getBlockEntity(pos) : null;
                if (ent != null && ent instanceof Container) {
                    Container container = (Container)ent;
                    this.internal = new ItemStackHandler(container.getContainerSize());
                    for (int i = 0; i < container.getContainerSize(); ++i) {
                        ((ItemStackHandler)this.internal).setStackInSlot(i, container.getItem(i));
                    }
                    this.bound = true;
                }
            }
        }
        this.customSlots.put(0, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 0, 8, 44){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(MONEY_TAG);
            }
        }));
        this.customSlots.put(1, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 1, 26, 44){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(MONEY_TAG);
            }
        }));
        this.customSlots.put(2, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 2, 44, 44){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(MONEY_TAG);
            }
        }));
        this.customSlots.put(3, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 3, 62, 44){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(MONEY_TAG);
            }
        }));
        this.customSlots.put(4, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 4, 80, 44){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(MONEY_TAG);
            }
        }));
        this.customSlots.put(5, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 5, 98, 44){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(MONEY_TAG);
            }
        }));
        this.customSlots.put(6, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 6, 116, 44){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(MONEY_TAG);
            }
        }));
        this.customSlots.put(7, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 7, 134, 44){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(MONEY_TAG);
            }
        }));
        this.customSlots.put(8, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 8, 152, 44){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(MONEY_TAG);
            }
        }));
        this.customSlots.put(9, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 9, 8, 62){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(MONEY_TAG);
            }
        }));
        this.customSlots.put(10, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 10, 26, 62){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(MONEY_TAG);
            }
        }));
        this.customSlots.put(11, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 11, 44, 62){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(MONEY_TAG);
            }
        }));
        this.customSlots.put(12, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 12, 62, 62){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(MONEY_TAG);
            }
        }));
        this.customSlots.put(13, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 13, 80, 62){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(MONEY_TAG);
            }
        }));
        this.customSlots.put(14, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 14, 98, 62){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(MONEY_TAG);
            }
        }));
        this.customSlots.put(15, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 15, 116, 62){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(MONEY_TAG);
            }
        }));
        this.customSlots.put(16, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 16, 134, 62){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(MONEY_TAG);
            }
        }));
        this.customSlots.put(17, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 17, 152, 62){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(MONEY_TAG);
            }
        }));
        for (si = 0; si < 3; ++si) {
            for (int sj = 0; sj < 9; ++sj) {
                this.addSlot(new Slot((Container)inv, sj + (si + 1) * 9, 8 + sj * 18, 84 + si * 18));
            }
        }
        si = 0;
        while (si < 9) {
            this.addSlot(new Slot((Container)inv, si, 8 + si * 18, 142));
            ++si;
        }
        return;
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < 18) {
                if (!this.moveItemStackTo(itemstack1, 18, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (!this.moveItemStackTo(itemstack1, 0, 18, false)) {
                if (index < 45 ? !this.moveItemStackTo(itemstack1, 45, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 18, 45, false)) {
                    return ItemStack.EMPTY;
                }
                return ItemStack.EMPTY;
            }
            if (itemstack1.getCount() == 0) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, itemstack1);
        }
        return itemstack;
    }

    protected boolean moveItemStackTo(ItemStack p_38904_, int p_38905_, int p_38906_, boolean p_38907_) {
        boolean flag = false;
        int i = p_38905_;
        if (p_38907_) {
            i = p_38906_ - 1;
        }
        if (p_38904_.isStackable()) {
            while (!p_38904_.isEmpty() && !(p_38907_ ? i < p_38905_ : i >= p_38906_)) {
                Slot slot = (Slot)this.slots.get(i);
                ItemStack itemstack = slot.getItem();
                if (slot.mayPlace(p_38904_) && !itemstack.isEmpty() && ItemStack.matches((ItemStack)p_38904_, (ItemStack)itemstack)) {
                    int maxSize;
                    int j = itemstack.getCount() + p_38904_.getCount();
                    if (j <= (maxSize = Math.min(slot.getMaxStackSize(), p_38904_.getMaxStackSize()))) {
                        p_38904_.setCount(0);
                        itemstack.setCount(j);
                        slot.set(itemstack);
                        flag = true;
                    } else if (itemstack.getCount() < maxSize) {
                        p_38904_.shrink(maxSize - itemstack.getCount());
                        itemstack.setCount(maxSize);
                        slot.set(itemstack);
                        flag = true;
                    }
                }
                if (p_38907_) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!p_38904_.isEmpty()) {
            i = p_38907_ ? p_38906_ - 1 : p_38905_;
            while (!(!p_38907_ ? i >= p_38906_ : i < p_38905_)) {
                Slot slot1 = (Slot)this.slots.get(i);
                ItemStack itemstack1 = slot1.getItem();
                if (itemstack1.isEmpty() && slot1.mayPlace(p_38904_)) {
                    if (p_38904_.getCount() > slot1.getMaxStackSize()) {
                        slot1.set(p_38904_.split(slot1.getMaxStackSize()));
                    } else {
                        slot1.set(p_38904_.split(p_38904_.getCount()));
                    }
                    slot1.setChanged();
                    flag = true;
                    break;
                }
                if (p_38907_) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public void removed(Player playerIn) {
        block23: {
            int i;
            block24: {
                super.removed(playerIn);
                if (this.bound || !(playerIn instanceof ServerPlayer)) break block24;
                ServerPlayer serverPlayer = (ServerPlayer)playerIn;
                if (!serverPlayer.isAlive() || serverPlayer.hasDisconnected()) {
                    for (int j = 0; j < this.internal.getSlots(); ++j) {
                        playerIn.drop(this.internal.extractItem(j, this.internal.getStackInSlot(j).getCount(), false), false);
                    }
                } else {
                    for (int i2 = 0; i2 < this.internal.getSlots(); ++i2) {
                        playerIn.getInventory().placeItemBackInInventory(this.internal.extractItem(i2, this.internal.getStackInSlot(i2).getCount(), false));
                    }
                }
                break block23;
            }
            if (!(playerIn instanceof ServerPlayer)) break block23;
            ServerPlayer serverPlayer = (ServerPlayer)playerIn;
            ItemStack[] walletStackRef = new ItemStack[1];
            int[] walletSlotRef = new int[1];
            for (i = 0; i < serverPlayer.getInventory().getContainerSize(); ++i) {
                ItemStack stack = serverPlayer.getInventory().getItem(i);
                if (!(stack.getItem() instanceof WalletItem) && !(stack.getItem() instanceof BlackWalletItem) && !(stack.getItem() instanceof BlueWalletItem) && !(stack.getItem() instanceof BrownWalletItem) && !(stack.getItem() instanceof GreenWalletItem) && !(stack.getItem() instanceof OrangeWalletItem) && !(stack.getItem() instanceof PurpleWalletItem) && !(stack.getItem() instanceof YellowWalletItem)) continue;
                walletStackRef[0] = stack;
                walletSlotRef[0] = i;
                break;
            }
            if (walletStackRef[0] != null) {
                ItemStack walletStack = walletStackRef[0];
                try {
                    ItemStack slotStack;
                    int i3;
                    CompoundTag nbt;
                    ItemStack slotStack2;
                    int i4;
                    ItemStackHandler tempHandler = new ItemStackHandler(this.internal.getSlots());
                    for (i4 = 0; i4 < this.internal.getSlots(); ++i4) {
                        slotStack2 = this.internal.getStackInSlot(i4);
                        if (!slotStack2.isEmpty()) {
                            SarosMoneyMod.LOGGER.info("GUI item in slot " + i4 + ": " + slotStack2.getItem().getClass().getSimpleName() + " x" + slotStack2.getCount());
                        }
                        tempHandler.setStackInSlot(i4, slotStack2.copy());
                    }
                    SarosMoneyMod.LOGGER.info("Checking temporary handler");
                    for (i4 = 0; i4 < tempHandler.getSlots(); ++i4) {
                        slotStack2 = tempHandler.getStackInSlot(i4);
                        if (slotStack2.isEmpty()) continue;
                        SarosMoneyMod.LOGGER.info("Temporary handler item in slot " + i4 + ": " + slotStack2.getItem().getClass().getSimpleName() + " x" + slotStack2.getCount());
                    }
                    CustomData customData = (CustomData)walletStack.get(DataComponents.CUSTOM_DATA);
                    if (customData != null && (nbt = customData.copyTag()).contains("Inventory")) {
                        CompoundTag inventoryTag = nbt.getCompound("Inventory");
                        ItemStackHandler walletHandler = new ItemStackHandler(18);
                        if (inventoryTag.contains("Items")) {
                            CompoundTag itemsTag = inventoryTag.getCompound("Items");
                            for (String key : itemsTag.getAllKeys()) {
                                if (!key.startsWith("slot_")) continue;
                                int slotIndex = Integer.parseInt(key.substring(5));
                                CompoundTag compoundTag = itemsTag.getCompound(key);
                            }
                        }
                    }
                    ItemStackHandler walletHandler2 = new ItemStackHandler(18);
                    SarosMoneyMod.LOGGER.info("Copying items to wallet handler");
                    for (i3 = 0; i3 < tempHandler.getSlots(); ++i3) {
                        slotStack = tempHandler.getStackInSlot(i3);
                        if (!slotStack.isEmpty()) {
                            SarosMoneyMod.LOGGER.info("Copying item in slot " + i3 + ": " + slotStack.getItem().getClass().getSimpleName() + " x" + slotStack.getCount());
                        }
                        walletHandler2.setStackInSlot(i3, slotStack);
                    }
                    SarosMoneyMod.LOGGER.info("Checking wallet handler after copying");
                    for (i3 = 0; i3 < walletHandler2.getSlots(); ++i3) {
                        slotStack = walletHandler2.getStackInSlot(i3);
                        if (slotStack.isEmpty()) continue;
                        SarosMoneyMod.LOGGER.info("Wallet handler item in slot " + i3 + ": " + slotStack.getItem().getClass().getSimpleName() + " x" + slotStack.getCount());
                    }
                    CompoundTag inventoryTag = new CompoundTag();
                    CompoundTag itemsTag = new CompoundTag();
                    for (int i5 = 0; i5 < walletHandler2.getSlots(); ++i5) {
                        ItemStack slotStack3 = walletHandler2.getStackInSlot(i5);
                        if (slotStack3.isEmpty()) continue;
                        CompoundTag itemTag = new CompoundTag();
                        slotStack3.save((HolderLookup.Provider)itemTag);
                        itemsTag.put("slot_" + i5, (Tag)itemTag);
                    }
                    inventoryTag.put("Items", (Tag)itemsTag);
                    CompoundTag nbt2 = ((CustomData)walletStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
                    nbt2.put("Inventory", (Tag)inventoryTag);
                    CustomData newCustomData = CustomData.of((CompoundTag)nbt2);
                    walletStack.set(DataComponents.CUSTOM_DATA, (Object)newCustomData);
                    try {
                        SarosMoneyMod.LOGGER.info("Speichere Inventar in Wallet beim Schlie\u00dfen der GUI");
                        CompoundTag inventoryTag2 = new CompoundTag();
                        CompoundTag itemsTag2 = new CompoundTag();
                        int itemCount = 0;
                        for (int i6 = 0; i6 < this.internal.getSlots(); ++i6) {
                            ItemStack slotStack4 = this.internal.getStackInSlot(i6);
                            if (slotStack4.isEmpty()) continue;
                            CompoundTag itemTag = new CompoundTag();
                            slotStack4.save((HolderLookup.Provider)itemTag);
                            itemsTag2.put("slot_" + i6, (Tag)itemTag);
                            SarosMoneyMod.LOGGER.info("Item in Slot " + i6 + " gespeichert: " + slotStack4.getItem().getClass().getSimpleName() + " x" + slotStack4.getCount());
                            ++itemCount;
                        }
                        SarosMoneyMod.LOGGER.info("Insgesamt " + itemCount + " Items gespeichert");
                        inventoryTag2.put("Items", (Tag)itemsTag2);
                        SarosMoneyMod.LOGGER.info("Inventardaten erstellt");
                        CompoundTag nbt22 = new CompoundTag();
                        nbt22.put("Inventory", (Tag)inventoryTag2);
                        CustomData newCustomData2 = CustomData.of((CompoundTag)nbt22);
                        walletStack.set(DataComponents.CUSTOM_DATA, (Object)newCustomData2);
                        SarosMoneyMod.LOGGER.info("CustomData gesetzt");
                        CustomData checkData = (CustomData)walletStack.get(DataComponents.CUSTOM_DATA);
                        if (checkData == null) break block23;
                        SarosMoneyMod.LOGGER.info("CustomData nach dem Setzen: " + String.valueOf(checkData));
                        if (!checkData.copyTag().contains("Inventory")) break block23;
                        SarosMoneyMod.LOGGER.info("Inventory wurde erfolgreich gespeichert!");
                        if (serverPlayer.containerMenu == null) break block23;
                        serverPlayer.containerMenu.broadcastChanges();
                        SarosMoneyMod.LOGGER.info("Inventar\u00e4nderungen an den Client gesendet");
                    }
                    catch (Exception e) {
                        SarosMoneyMod.LOGGER.error("Fehler beim Aktualisieren des Wallet-Stacks: " + e.getMessage());
                        e.printStackTrace();
                    }
                }
                catch (Exception e) {
                    SarosMoneyMod.LOGGER.error("Fehler beim Aktualisieren des Wallet-Stacks: " + e.getMessage());
                    e.printStackTrace();
                }
            } else {
                for (i = 0; i < this.internal.getSlots(); ++i) {
                    playerIn.getInventory().placeItemBackInInventory(this.internal.extractItem(i, this.internal.getStackInSlot(i).getCount(), false));
                }
            }
        }
    }

    @Override
    public Map<Integer, Slot> get() {
        return this.customSlots;
    }
}

