/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod;

import de.sarocesch.sarosmoneymod.ModDataComponents;
import de.sarocesch.sarosmoneymod.data.BalanceMigrator;
import de.sarocesch.sarosmoneymod.init.SarosMoneyModModBlockEntities;
import de.sarocesch.sarosmoneymod.init.SarosMoneyModModBlocks;
import de.sarocesch.sarosmoneymod.init.SarosMoneyModModItems;
import de.sarocesch.sarosmoneymod.init.SarosMoneyModModMenus;
import de.sarocesch.sarosmoneymod.init.SarosMoneyModModTabs;
import de.sarocesch.sarosmoneymod.listener.SignShopListener;
import de.sarocesch.sarosmoneymod.network.NetworkHandler;
import de.sarocesch.sarosmoneymod.villager.ModVillagers;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="saros__money_mod")
public class SarosMoneyModMod {
    public static final Logger LOGGER = LogManager.getLogger(SarosMoneyModMod.class);
    public static final String MODID = "saros__money_mod";
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public SarosMoneyModMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModDataComponents.register(bus);
        MinecraftForge.EVENT_BUS.register((Object)new SignShopListener());
        SarosMoneyModModBlocks.REGISTRY.register(bus);
        SarosMoneyModModItems.REGISTRY.register(bus);
        SarosMoneyModModTabs.REGISTRY.register(bus);
        SarosMoneyModModBlockEntities.REGISTRY.register(bus);
        ModVillagers.register(bus);
        bus.addListener(this::commonSetup);
        SarosMoneyModModMenus.REGISTRY.register(bus);
    }

    @SubscribeEvent
    public static void serverLoad(ServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        BalanceMigrator.migrateOldData(server);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> NetworkHandler.register());
    }

    public static void queueServerWork(int tick, Runnable action) {
        workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        TickEvent.Phase phase = event.phase;
        if (phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }
}

