/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.sarocesch.sarosmoneymod.data.BalanceManager;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class MoneyCommand {
    @SubscribeEvent
    public static void registerCommand(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.literal((String)"money").executes(MoneyCommand::showBalance));
    }

    private static int showBalance(CommandContext<CommandSourceStack> context) {
        ServerPlayer player;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            player = source.getPlayerOrException();
        }
        catch (CommandSyntaxException e) {
            source.sendFailure((Component)Component.translatable((String)"command.money.not_a_player"));
            return 0;
        }
        String playerUUID = player.getUUID().toString();
        Map<String, Double> balances = BalanceManager.loadBalances(source.getServer());
        double balance = balances.getOrDefault(playerUUID, 0.0);
        player.sendSystemMessage((Component)Component.translatable((String)"command.money.balance", (Object[])new Object[]{String.format("%.2f", balance)}));
        return 1;
    }
}

