/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.item.inventory;

import de.sarocesch.sarosmoneymod.client.gui.WalletGUIScreen;
import de.sarocesch.sarosmoneymod.init.SarosMoneyModModItems;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemStackHandler;

@Mod.EventBusSubscriber(modid="saros_money_mod", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class WalletInventoryCapability {
    private final LazyOptional<ItemStackHandler> inventory = LazyOptional.of(this::createItemHandler);

    @SubscribeEvent
    public static void onItemDropped(ItemTossEvent event) {
        if (event.getEntity().getItem().getItem() == SarosMoneyModModItems.WALLET.get() && Minecraft.getInstance().screen instanceof WalletGUIScreen) {
            Minecraft.getInstance().player.closeContainer();
        }
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        return capability == ForgeCapabilities.ITEM_HANDLER ? this.inventory.cast() : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        HolderLookup.Provider provider = (HolderLookup.Provider)BuiltInRegistries.REGISTRY.asLookup();
        return this.getItemHandler().serializeNBT(provider);
    }

    public void deserializeNBT(CompoundTag nbt) {
        HolderLookup.Provider provider = (HolderLookup.Provider)BuiltInRegistries.REGISTRY.asLookup();
        this.getItemHandler().deserializeNBT(provider, nbt);
    }

    private ItemStackHandler createItemHandler() {
        return new ItemStackHandler(this, 18){

            public int getSlotLimit(int slot) {
                return 64;
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.getItem() != SarosMoneyModModItems.WALLET.get();
            }

            public void setSize(int size) {
            }
        };
    }

    private ItemStackHandler getItemHandler() {
        return (ItemStackHandler)this.inventory.orElseThrow(RuntimeException::new);
    }
}

