/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.world.inventory;

import de.sarocesch.sarosmoneymod.data.BalanceManager;
import de.sarocesch.sarosmoneymod.init.SarosMoneyModModMenus;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ATMGUIMenu
extends AbstractContainerMenu
implements Supplier<Map<Integer, Slot>> {
    public static final HashMap<String, Object> guistate = new HashMap();
    public final Level world;
    public final Player entity;
    public int x;
    public int y;
    public int z;
    private IItemHandler internal;
    private final Map<Integer, Slot> customSlots = new HashMap<Integer, Slot>();
    private boolean bound = false;
    public final DataSlot balance = DataSlot.standalone();

    public ATMGUIMenu(int id, Inventory inv, FriendlyByteBuf extraData) {
        super((MenuType)SarosMoneyModModMenus.ATMGUI.get(), id);
        int si;
        this.entity = inv.player;
        this.world = inv.player.level();
        this.internal = new ItemStackHandler(1);
        BlockPos pos = null;
        this.addDataSlot(this.balance);
        if (!inv.player.level().isClientSide()) {
            ServerPlayer serverPlayer = (ServerPlayer)inv.player;
            this.balance.set((int)(BalanceManager.getPlayerBalance(serverPlayer) * 100.0));
        } else {
            this.balance.set(0);
        }
        if (extraData != null) {
            pos = extraData.readBlockPos();
            this.x = pos.getX();
            this.y = pos.getY();
            this.z = pos.getZ();
        }
        if (pos != null) {
            if (extraData.readableBytes() == 1) {
                CompoundTag nbt;
                byte hand = extraData.readByte();
                ItemStack itemstack = hand == 0 ? this.entity.getMainHandItem() : this.entity.getOffhandItem();
                CustomData customData = (CustomData)itemstack.get(DataComponents.CUSTOM_DATA);
                if (customData != null && (nbt = customData.copyTag()).contains("Inventory")) {
                    block21: {
                        CompoundTag inventoryTag = nbt.getCompound("Inventory");
                        this.internal = new ItemStackHandler(9);
                        try {
                            Method method = ((ItemStackHandler)this.internal).getClass().getMethod("deserializeNBT", CompoundTag.class);
                            method.invoke((Object)((ItemStackHandler)this.internal), inventoryTag);
                        }
                        catch (Exception e) {
                            if (!inventoryTag.contains("Items")) break block21;
                            CompoundTag itemsTag = inventoryTag.getCompound("Items");
                            for (String key : itemsTag.getAllKeys()) {
                                ItemStack itemStack;
                                int slotIndex;
                                block22: {
                                    if (!key.startsWith("slot_")) continue;
                                    slotIndex = Integer.parseInt(key.substring(5));
                                    CompoundTag itemTag = itemsTag.getCompound(key);
                                    itemStack = ItemStack.EMPTY;
                                    try {
                                        Optional optional;
                                        Method method = ItemStack.class.getMethod("parseOptional", HolderLookup.Provider.class, CompoundTag.class);
                                        RegistryAccess registryAccess = this.entity.level().registryAccess();
                                        Object result = method.invoke(null, registryAccess, itemTag);
                                        if (result instanceof Optional && (optional = (Optional)result).isPresent() && optional.get() instanceof ItemStack) {
                                            itemStack = (ItemStack)optional.get();
                                        }
                                    }
                                    catch (Exception ex) {
                                        if (!itemTag.contains("id")) break block22;
                                        String itemId = itemTag.getString("id");
                                        int count = itemTag.contains("Count") ? itemTag.getInt("Count") : 1;
                                        String namespace = "minecraft";
                                        String path = itemId;
                                        if (itemId.contains(":")) {
                                            String[] parts = itemId.split(":", 2);
                                            namespace = parts[0];
                                            path = parts[1];
                                        }
                                        Item itemObj = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)(namespace + ":" + path)));
                                        itemStack = new ItemStack((ItemLike)itemObj, count);
                                        if (!itemTag.contains("tag")) break block22;
                                        CompoundTag tag = itemTag.getCompound("tag");
                                        itemStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
                                    }
                                }
                                ((ItemStackHandler)this.internal).setStackInSlot(slotIndex, itemStack);
                            }
                        }
                    }
                    this.bound = true;
                }
            } else if (extraData.readableBytes() > 1) {
                extraData.readByte();
                Entity entity = this.world.getEntity(extraData.readVarInt());
                if (entity != null) {
                    entity.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> {
                        this.internal = capability;
                        this.bound = true;
                    });
                }
            } else {
                BlockEntity ent;
                BlockEntity blockEntity = ent = inv.player != null ? inv.player.level().getBlockEntity(pos) : null;
                if (ent != null) {
                    ent.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> {
                        this.internal = capability;
                        this.bound = true;
                    });
                }
            }
        }
        this.customSlots.put(0, this.addSlot((Slot)new SlotItemHandler(this, this.internal, 0, 25, 63){
            private final int slot = 0;
        }));
        for (si = 0; si < 3; ++si) {
            for (int sj = 0; sj < 9; ++sj) {
                this.addSlot(new Slot((Container)inv, sj + (si + 1) * 9, 8 + sj * 18, 84 + si * 18));
            }
        }
        for (si = 0; si < 9; ++si) {
            this.addSlot(new Slot((Container)inv, si, 8 + si * 18, 142));
        }
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < 1) {
                if (!this.moveItemStackTo(itemstack1, 1, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (!this.moveItemStackTo(itemstack1, 0, 1, false)) {
                if (index < 28 ? !this.moveItemStackTo(itemstack1, 28, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 1, 28, false)) {
                    return ItemStack.EMPTY;
                }
                return ItemStack.EMPTY;
            }
            if (itemstack1.getCount() == 0) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, itemstack1);
        }
        return itemstack;
    }

    protected boolean moveItemStackTo(ItemStack p_38904_, int p_38905_, int p_38906_, boolean p_38907_) {
        boolean flag = false;
        int i = p_38905_;
        if (p_38907_) {
            i = p_38906_ - 1;
        }
        if (p_38904_.isStackable()) {
            while (!p_38904_.isEmpty() && !(p_38907_ ? i < p_38905_ : i >= p_38906_)) {
                Slot slot = (Slot)this.slots.get(i);
                ItemStack itemstack = slot.getItem();
                if (slot.mayPlace(p_38904_) && !itemstack.isEmpty() && ItemStack.isSameItem((ItemStack)p_38904_, (ItemStack)itemstack)) {
                    int maxSize;
                    int j = itemstack.getCount() + p_38904_.getCount();
                    if (j <= (maxSize = Math.min(slot.getMaxStackSize(), p_38904_.getMaxStackSize()))) {
                        p_38904_.setCount(0);
                        itemstack.setCount(j);
                        slot.set(itemstack);
                        flag = true;
                    } else if (itemstack.getCount() < maxSize) {
                        p_38904_.shrink(maxSize - itemstack.getCount());
                        itemstack.setCount(maxSize);
                        slot.set(itemstack);
                        flag = true;
                    }
                }
                if (p_38907_) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!p_38904_.isEmpty()) {
            i = p_38907_ ? p_38906_ - 1 : p_38905_;
            while (!(!p_38907_ ? i >= p_38906_ : i < p_38905_)) {
                Slot slot1 = (Slot)this.slots.get(i);
                ItemStack itemstack1 = slot1.getItem();
                if (itemstack1.isEmpty() && slot1.mayPlace(p_38904_)) {
                    if (p_38904_.getCount() > slot1.getMaxStackSize()) {
                        slot1.set(p_38904_.split(slot1.getMaxStackSize()));
                    } else {
                        slot1.set(p_38904_.split(p_38904_.getCount()));
                    }
                    slot1.setChanged();
                    flag = true;
                    break;
                }
                if (p_38907_) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public double getBalance() {
        return (double)this.balance.get() / 100.0;
    }

    public void removed(Player playerIn) {
        block4: {
            super.removed(playerIn);
            if (this.bound || !(playerIn instanceof ServerPlayer)) break block4;
            ServerPlayer serverPlayer = (ServerPlayer)playerIn;
            if (!serverPlayer.isAlive() || serverPlayer.hasDisconnected()) {
                for (int j = 0; j < this.internal.getSlots(); ++j) {
                    playerIn.drop(this.internal.extractItem(j, this.internal.getStackInSlot(j).getCount(), false), false);
                }
            } else {
                for (int i = 0; i < this.internal.getSlots(); ++i) {
                    playerIn.getInventory().placeItemBackInInventory(this.internal.extractItem(i, this.internal.getStackInSlot(i).getCount(), false));
                }
            }
        }
    }

    @Override
    public Map<Integer, Slot> get() {
        return this.customSlots;
    }
}

