/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod;

import de.sarocesch.sarosmoneymod.data.BalanceManager;
import de.sarocesch.sarosmoneymod.data.BalanceMigrator;
import de.sarocesch.sarosmoneymod.init.SarosMoneyModModBlockEntities;
import de.sarocesch.sarosmoneymod.init.SarosMoneyModModBlocks;
import de.sarocesch.sarosmoneymod.init.SarosMoneyModModItems;
import de.sarocesch.sarosmoneymod.init.SarosMoneyModModMenus;
import de.sarocesch.sarosmoneymod.init.SarosMoneyModModTabs;
import de.sarocesch.sarosmoneymod.listener.SignShopListener;
import de.sarocesch.sarosmoneymod.network.NetworkHandler;
import de.sarocesch.sarosmoneymod.villager.ModVillagers;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.server.MinecraftServer;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="saros__money_mod")
public class SarosMoneyModMod {
    public static final Logger LOGGER = LogManager.getLogger(SarosMoneyModMod.class);
    public static final String MODID = "saros__money_mod";
    private final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public SarosMoneyModMod(IEventBus modEventBus) {
        NeoForge.EVENT_BUS.register((Object)new SignShopListener());
        NeoForge.EVENT_BUS.register(BalanceManager.class);
        IEventBus bus = modEventBus;
        bus.addListener(NetworkHandler::register);
        SarosMoneyModModBlocks.REGISTRY.register(bus);
        SarosMoneyModModItems.REGISTRY.register(bus);
        SarosMoneyModModTabs.REGISTRY.register(bus);
        SarosMoneyModModBlockEntities.REGISTRY.register(bus);
        ModVillagers.register(bus);
        SarosMoneyModModMenus.REGISTRY.register(bus);
    }

    @SubscribeEvent
    public void serverLoad(ServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        BalanceManager.setCurrentServer(server);
        BalanceMigrator.migrateOldData(server);
    }

    public void queueServerWork(int tick, Runnable action) {
        this.workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
    }

    @SubscribeEvent
    public void tick(ServerTickEvent.Post event) {
        ArrayList actions = new ArrayList();
        this.workQueue.forEach(work -> {
            work.setValue((Integer)work.getValue() - 1);
            if ((Integer)work.getValue() == 0) {
                actions.add(work);
            }
        });
        actions.forEach(e -> ((Runnable)e.getKey()).run());
        this.workQueue.removeAll(actions);
    }
}

