/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.sarocesch.sarosmoneymod.data.BalanceManager;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

@EventBusSubscriber(modid="saros__money_mod")
public class PayCommand {
    private static final SuggestionProvider<CommandSourceStack> PLAYER_NAMES = (context, builder) -> SharedSuggestionProvider.suggest((Iterable)((CommandSourceStack)context.getSource()).getOnlinePlayerNames(), (SuggestionsBuilder)builder);

    @SubscribeEvent
    public static void registerCommand(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.literal((String)"pay").then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).suggests(PLAYER_NAMES).then(Commands.argument((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg((double)0.01)).executes(PayCommand::pay))));
    }

    private static int pay(CommandContext<CommandSourceStack> context) {
        ServerPlayer sender;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            sender = source.getPlayerOrException();
        }
        catch (CommandSyntaxException e) {
            source.sendFailure((Component)Component.translatable((String)"command.pay.sender_not_player").withStyle(ChatFormatting.RED));
            return 0;
        }
        String targetPlayerName = StringArgumentType.getString(context, (String)"player");
        double amount = DoubleArgumentType.getDouble(context, (String)"amount");
        MinecraftServer server = source.getServer();
        String senderUUID = sender.getUUID().toString();
        double senderBalance = BalanceManager.getBalance(senderUUID);
        if (senderBalance < amount) {
            sender.sendSystemMessage((Component)Component.translatable((String)"command.pay.not_enough_money").withStyle(ChatFormatting.RED));
            return 0;
        }
        ServerPlayer targetPlayer = server.getPlayerList().getPlayerByName(targetPlayerName);
        if (targetPlayer == null) {
            sender.sendSystemMessage((Component)Component.translatable((String)"command.pay.player_not_found", (Object[])new Object[]{targetPlayerName}).withStyle(ChatFormatting.RED));
            return 0;
        }
        String targetUUID = targetPlayer.getUUID().toString();
        double targetBalance = BalanceManager.getBalance(targetUUID);
        BalanceManager.setBalance(senderUUID, senderBalance - amount);
        BalanceManager.setBalance(targetUUID, targetBalance + amount);
        sender.sendSystemMessage((Component)Component.translatable((String)"command.pay.success_sender", (Object[])new Object[]{String.format("%.2f", amount), targetPlayerName}).withStyle(ChatFormatting.GREEN));
        targetPlayer.sendSystemMessage((Component)Component.translatable((String)"command.pay.success_receiver", (Object[])new Object[]{String.format("%.2f", amount), sender.getName().getString()}).withStyle(ChatFormatting.GREEN));
        return 1;
    }
}

