/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.data;

import de.sarocesch.sarosmoneymod.Config;
import de.sarocesch.sarosmoneymod.data.BalanceData;
import java.util.Map;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;

public class BalanceManager {
    private static MinecraftServer currentServer;

    public static void addMoneyToPlayer(MinecraftServer server, String playerUUID, double amount) {
        double current = BalanceManager.getBalance(playerUUID);
        BalanceManager.setBalance(playerUUID, current + amount);
    }

    public static Map<String, Double> loadBalances(MinecraftServer server) {
        return BalanceData.get(server).getAllBalances();
    }

    public static double getPlayerBalance(ServerPlayer player) {
        return BalanceManager.getBalance(player.getUUID().toString());
    }

    public static void updatePlayerBalance(ServerPlayer player, double newBalance) {
        BalanceManager.setBalance(player.getUUID().toString(), newBalance);
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        currentServer = event.getServer();
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player;
        String uuid;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && BalanceManager.getBalance(uuid = (player = (ServerPlayer)player2).getUUID().toString()) == 0.0) {
            BalanceManager.setBalance(uuid, Config.START_MONEY);
        }
    }

    public static void setCurrentServer(MinecraftServer server) {
        currentServer = server;
    }

    public static MinecraftServer getCurrentServer() {
        return currentServer;
    }

    public static double getBalance(String playerUUID) {
        MinecraftServer server = BalanceManager.getCurrentServer();
        if (server == null) {
            return 0.0;
        }
        BalanceData data = BalanceData.get(server);
        return data.getBalance(playerUUID);
    }

    public static void setBalance(String playerUUID, double balance) {
        MinecraftServer server = BalanceManager.getCurrentServer();
        if (server == null) {
            return;
        }
        BalanceData data = BalanceData.get(server);
        data.setBalance(playerUUID, balance);
    }
}

