/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.item;

import de.sarocesch.sarosmoneymod.world.inventory.WalletGUIMenu;
import io.netty.buffer.Unpooled;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;

public class BlueWalletItem
extends Item {
    public BlueWalletItem() {
        super(new Item.Properties().stacksTo(1).rarity(Rarity.COMMON));
    }

    public InteractionResultHolder<ItemStack> use(Level world, final Player entity, final InteractionHand hand) {
        InteractionResultHolder ar = super.use(world, entity, hand);
        ItemStack itemstack = (ItemStack)ar.getObject();
        if (!world.isClientSide()) {
            this.initInventoryData(itemstack);
            entity.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return Component.literal((String)"Blue Wallet");
                }

                public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                    FriendlyByteBuf packetBuffer = new FriendlyByteBuf(Unpooled.buffer());
                    packetBuffer.writeBlockPos(entity.blockPosition());
                    packetBuffer.writeInt(hand == InteractionHand.MAIN_HAND ? 0 : 1);
                    return new WalletGUIMenu(id, inventory, packetBuffer);
                }
            });
        }
        return ar;
    }

    private void initInventoryData(ItemStack stack) {
        if (!stack.has(DataComponents.CUSTOM_DATA)) {
            CompoundTag nbt = new CompoundTag();
            CompoundTag inventoryTag = new CompoundTag();
            inventoryTag.putInt("Size", 18);
            nbt.put("Inventory", (Tag)inventoryTag);
            stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)nbt));
        }
    }
}

