/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.listener;

import de.sarocesch.sarosmoneymod.Config;
import de.sarocesch.sarosmoneymod.data.BalanceData;
import de.sarocesch.sarosmoneymod.data.BalanceManager;
import de.sarocesch.sarosmoneymod.data.BalanceMigrator;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class BalanceJoin {
    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        new BalanceJoin();
    }

    @EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
    private static class ClientEvents {
        private ClientEvents() {
        }

        @SubscribeEvent
        public static void clientLoad(FMLClientSetupEvent event) {
        }
    }

    @EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME)
    private static class GameEvents {
        private GameEvents() {
        }

        @SubscribeEvent
        public static void serverLoad(ServerAboutToStartEvent event) {
            MinecraftServer server = event.getServer();
            BalanceMigrator.migrateOldData(server);
        }

        @SubscribeEvent
        public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
            if (event.getEntity() instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)event.getEntity();
                MinecraftServer server = player.getServer();
                if (server == null) {
                    return;
                }
                if (!BalanceData.get(server).containsBalance(player.getUUID().toString())) {
                    BalanceManager.setBalance(player.getUUID().toString(), Config.START_MONEY);
                }
            }
        }
    }
}

