/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.listener;

import de.sarocesch.sarosmoneymod.Config;
import de.sarocesch.sarosmoneymod.data.BalanceManager;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;

@EventBusSubscriber(modid="saros__money_mod")
public class DeathMoneyListener {
    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        int deathMoneyLoss = Config.MONEY_LOSS_ON_DEATH;
        if (deathMoneyLoss == 0) {
            return;
        }
        String playerUUID = player.getUUID().toString();
        double balance = BalanceManager.getBalance(playerUUID);
        double newBalance = Math.max(balance - (double)deathMoneyLoss, 0.0);
        BalanceManager.setBalance(playerUUID, newBalance);
        player.sendSystemMessage((Component)Component.translatable((String)"message.death_money_loss", (Object[])new Object[]{deathMoneyLoss, newBalance}));
    }
}

