/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.listener;

import de.sarocesch.sarosmoneymod.Config;
import de.sarocesch.sarosmoneymod.data.BalanceManager;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber
public class Paycheck {
    private static long lastPaycheckTime = 0L;
    private static final long PAYCHECK_INTERVAL = TimeUnit.MINUTES.toMillis(30L);

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        MinecraftServer server = event.getServer();
        long currentTime = System.currentTimeMillis();
        if (Config.PAYCHECK_ENABLED && currentTime - lastPaycheckTime >= PAYCHECK_INTERVAL) {
            lastPaycheckTime = currentTime;
            Paycheck.payPlayers(server);
        }
    }

    private static void payPlayers(MinecraftServer server) {
        List players = server.getPlayerList().getPlayers();
        for (ServerPlayer player : players) {
            String playerUUID = player.getUUID().toString();
            double paycheckAmount = Config.PAYCHECK_AMOUNT;
            BalanceManager.addMoneyToPlayer(server, playerUUID, paycheckAmount);
            player.sendSystemMessage((Component)Component.translatable((String)"message.sarosmoneymod.paycheck", (Object[])new Object[]{paycheckAmount}));
        }
    }
}

