/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.listener;

import de.sarocesch.sarosmoneymod.SarosMoneyModMod;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractSignEditScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ScreenEvent;

@EventBusSubscriber(modid="saros__money_mod", value={Dist.CLIENT})
public class SignShopClientListener {
    private static Field signField;

    private static void initSignField() {
        try {
            signField = AbstractSignEditScreen.class.getDeclaredField("sign");
            signField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            try {
                signField = AbstractSignEditScreen.class.getDeclaredField("blockEntity");
                signField.setAccessible(true);
            }
            catch (NoSuchFieldException e2) {
                SarosMoneyModMod.LOGGER.error("Failed to find sign field with both 'sign' and 'blockEntity' names:", (Throwable)e2);
            }
        }
        catch (Exception e) {
            SarosMoneyModMod.LOGGER.error("Failed to find sign field:", (Throwable)e);
        }
    }

    @SubscribeEvent
    public static void onScreenInit(ScreenEvent.Init.Pre event) {
        if (event.getScreen() instanceof AbstractSignEditScreen && signField == null) {
            SignShopClientListener.initSignField();
        }
    }

    @SubscribeEvent
    public static void onScreenClose(ScreenEvent.Closing event) {
        Screen screen = event.getScreen();
        if (screen instanceof AbstractSignEditScreen) {
            AbstractSignEditScreen screen2 = (AbstractSignEditScreen)screen;
            try {
                SignBlockEntity sign;
                if (signField == null) {
                    SignShopClientListener.initSignField();
                }
                if ((sign = (SignBlockEntity)signField.get(screen2)) != null) {
                    boolean isShop;
                    SignText signText = sign.getText(true);
                    Component[] messages = signText.getMessages(true);
                    String firstLine = messages[0].getString().trim().toLowerCase();
                    boolean bl = isShop = firstLine.contains("shop") || firstLine.contains("buy") || firstLine.contains("sell");
                    if (isShop) {
                        SarosMoneyModMod.LOGGER.debug("Detected shop sign creation, sending to server");
                    }
                    Minecraft.getInstance().tell(() -> SignShopClientListener.updateSign(sign));
                }
            }
            catch (Exception e) {
                SarosMoneyModMod.LOGGER.error("Error processing sign edit screen closing:", (Throwable)e);
            }
        }
    }

    private static void updateSign(SignBlockEntity sign) {
        try {
            sign.setChanged();
            Level level = sign.getLevel();
            if (level != null) {
                level.sendBlockUpdated(sign.getBlockPos(), level.getBlockState(sign.getBlockPos()), level.getBlockState(sign.getBlockPos()), 3);
            }
            SarosMoneyModMod.LOGGER.info("Sign updated at " + String.valueOf(sign.getBlockPos()));
        }
        catch (Exception e) {
            SarosMoneyModMod.LOGGER.error("Sign update failed", (Throwable)e);
        }
    }
}

