/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod.network;

import de.sarocesch.sarosmoneymod.SarosMoneyModMod;
import de.sarocesch.sarosmoneymod.data.BalanceManager;
import de.sarocesch.sarosmoneymod.procedures.DepositProcedure;
import de.sarocesch.sarosmoneymod.procedures.WithdrawProcedure;
import de.sarocesch.sarosmoneymod.world.inventory.ATMGUIMenu;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;

public record ATMGUIButtonMessage(int buttonID, BlockPos pos, String withdrawValue) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"saros__money_mod", (String)"atmgui_button");
    public static final CustomPacketPayload.Type<ATMGUIButtonMessage> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, ATMGUIButtonMessage> STREAM_CODEC = StreamCodec.of((buf, msg) -> {
        buf.writeInt(msg.buttonID());
        buf.writeBlockPos(msg.pos());
        buf.writeUtf(msg.withdrawValue(), Short.MAX_VALUE);
    }, buf -> new ATMGUIButtonMessage(buf.readInt(), buf.readBlockPos(), buf.readUtf(Short.MAX_VALUE)));

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(ATMGUIButtonMessage message, Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Level world = serverPlayer.level();
            HashMap<String, Object> guistate = ATMGUIMenu.guistate;
            try {
                String value = message.withdrawValue();
                if (value == null || value.trim().isEmpty()) {
                    value = "0";
                }
                switch (message.buttonID()) {
                    case 0: {
                        WithdrawProcedure.execute((Entity)serverPlayer, guistate, value, serverPlayer);
                        break;
                    }
                    case 1: {
                        DepositProcedure.execute((Entity)serverPlayer, guistate, value, serverPlayer);
                        break;
                    }
                    default: {
                        SarosMoneyModMod.LOGGER.warn("Unknown button ID: " + message.buttonID());
                    }
                }
                double playerBalance = BalanceManager.getPlayerBalance(serverPlayer);
                int newBalance = (int)(playerBalance * 100.0);
                AbstractContainerMenu abstractContainerMenu = serverPlayer.containerMenu;
                if (abstractContainerMenu instanceof ATMGUIMenu) {
                    ATMGUIMenu menu = (ATMGUIMenu)abstractContainerMenu;
                    menu.balance.set(newBalance);
                    menu.broadcastChanges();
                }
            }
            catch (Exception e) {
                SarosMoneyModMod.LOGGER.error("Error handling ATM button click", (Throwable)e);
            }
        } else {
            SarosMoneyModMod.LOGGER.error("Player is not a ServerPlayer!");
        }
    }
}

