/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Config {
    private static final Logger LOGGER = LogManager.getLogger(Config.class);
    public static int START_MONEY = 100;
    public static int MONEY_LOSS_ON_DEATH = 0;
    public static boolean PAYCHECK_ENABLED = false;
    public static int PAYCHECK_AMOUNT = 50;
    public static boolean VILLAGER_TRADES_ENABLED = true;
    public static int TRADE_L1_RAW_IRON_AMOUNT = 5;
    public static int TRADE_L2_DIAMOND_AMOUNT = 3;
    public static int TRADE_L3_RAW_COPPER_AMOUNT = 5;
    public static int TRADE_L4_RAW_IRON_AMOUNT = 3;
    public static int TRADE_L4_DIAMOND_AMOUNT = 2;
    public static int TRADE_L5_GOLDEN_APPLE_AMOUNT = 1;
    public static int TRADE_L5_NETHER_STAR_AMOUNT = 1;

    public static void init() {
        Config.loadConfig();
    }

    public static void loadConfig() {
        File configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), "saros_money_mod.json");
        if (!configFile.exists()) {
            Config.createDefaultConfig(configFile);
        } else {
            try (FileReader reader = new FileReader(configFile);){
                boolean configUpdated;
                JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                START_MONEY = json.has("startMoney") ? json.get("startMoney").getAsInt() : 1000;
                MONEY_LOSS_ON_DEATH = json.has("moneyLossOnDeath") ? json.get("moneyLossOnDeath").getAsInt() : 0;
                PAYCHECK_ENABLED = json.has("paycheckEnabled") ? json.get("paycheckEnabled").getAsBoolean() : false;
                int n = PAYCHECK_AMOUNT = json.has("paycheckAmount") ? json.get("paycheckAmount").getAsInt() : 50;
                if (json.has("villagerConfig")) {
                    JsonObject villagerConfig = json.getAsJsonObject("villagerConfig");
                    VILLAGER_TRADES_ENABLED = villagerConfig.has("tradesEnabled") ? villagerConfig.get("tradesEnabled").getAsBoolean() : true;
                    TRADE_L1_RAW_IRON_AMOUNT = villagerConfig.has("tradeL1RawIronAmount") ? villagerConfig.get("tradeL1RawIronAmount").getAsInt() : 5;
                    TRADE_L2_DIAMOND_AMOUNT = villagerConfig.has("tradeL2DiamondAmount") ? villagerConfig.get("tradeL2DiamondAmount").getAsInt() : 3;
                    TRADE_L3_RAW_COPPER_AMOUNT = villagerConfig.has("tradeL3RawCopperAmount") ? villagerConfig.get("tradeL3RawCopperAmount").getAsInt() : 5;
                    TRADE_L4_RAW_IRON_AMOUNT = villagerConfig.has("tradeL4RawIronAmount") ? villagerConfig.get("tradeL4RawIronAmount").getAsInt() : 3;
                    TRADE_L4_DIAMOND_AMOUNT = villagerConfig.has("tradeL4DiamondAmount") ? villagerConfig.get("tradeL4DiamondAmount").getAsInt() : 2;
                    TRADE_L5_GOLDEN_APPLE_AMOUNT = villagerConfig.has("tradeL5GoldenAppleAmount") ? villagerConfig.get("tradeL5GoldenAppleAmount").getAsInt() : 1;
                    int n2 = TRADE_L5_NETHER_STAR_AMOUNT = villagerConfig.has("tradeL5NetherStarAmount") ? villagerConfig.get("tradeL5NetherStarAmount").getAsInt() : 1;
                }
                if (configUpdated = Config.updateConfigIfNeeded(json, configFile)) {
                    LOGGER.info("Config file updated with new values");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean updateConfigIfNeeded(JsonObject existingConfig, File configFile) {
        JsonObject villagerConfig;
        boolean configUpdated = false;
        if (!existingConfig.has("startMoney")) {
            existingConfig.addProperty("startMoney", (Number)START_MONEY);
            configUpdated = true;
        }
        if (!existingConfig.has("moneyLossOnDeath")) {
            existingConfig.addProperty("moneyLossOnDeath", (Number)MONEY_LOSS_ON_DEATH);
            configUpdated = true;
        }
        if (!existingConfig.has("paycheckEnabled")) {
            existingConfig.addProperty("paycheckEnabled", Boolean.valueOf(PAYCHECK_ENABLED));
            configUpdated = true;
        }
        if (!existingConfig.has("paycheckAmount")) {
            existingConfig.addProperty("paycheckAmount", (Number)PAYCHECK_AMOUNT);
            configUpdated = true;
        }
        if (!existingConfig.has("villagerConfig")) {
            villagerConfig = new JsonObject();
            existingConfig.add("villagerConfig", (JsonElement)villagerConfig);
            configUpdated = true;
        } else {
            villagerConfig = existingConfig.getAsJsonObject("villagerConfig");
        }
        if (!villagerConfig.has("tradesEnabled")) {
            villagerConfig.addProperty("tradesEnabled", Boolean.valueOf(VILLAGER_TRADES_ENABLED));
            configUpdated = true;
        }
        if (!villagerConfig.has("tradeL1RawIronAmount")) {
            villagerConfig.addProperty("tradeL1RawIronAmount", (Number)TRADE_L1_RAW_IRON_AMOUNT);
            configUpdated = true;
        }
        if (!villagerConfig.has("tradeL2DiamondAmount")) {
            villagerConfig.addProperty("tradeL2DiamondAmount", (Number)TRADE_L2_DIAMOND_AMOUNT);
            configUpdated = true;
        }
        if (!villagerConfig.has("tradeL3RawCopperAmount")) {
            villagerConfig.addProperty("tradeL3RawCopperAmount", (Number)TRADE_L3_RAW_COPPER_AMOUNT);
            configUpdated = true;
        }
        if (!villagerConfig.has("tradeL4RawIronAmount")) {
            villagerConfig.addProperty("tradeL4RawIronAmount", (Number)TRADE_L4_RAW_IRON_AMOUNT);
            configUpdated = true;
        }
        if (!villagerConfig.has("tradeL4DiamondAmount")) {
            villagerConfig.addProperty("tradeL4DiamondAmount", (Number)TRADE_L4_DIAMOND_AMOUNT);
            configUpdated = true;
        }
        if (!villagerConfig.has("tradeL5GoldenAppleAmount")) {
            villagerConfig.addProperty("tradeL5GoldenAppleAmount", (Number)TRADE_L5_GOLDEN_APPLE_AMOUNT);
            configUpdated = true;
        }
        if (!villagerConfig.has("tradeL5NetherStarAmount")) {
            villagerConfig.addProperty("tradeL5NetherStarAmount", (Number)TRADE_L5_NETHER_STAR_AMOUNT);
            configUpdated = true;
        }
        if (configUpdated) {
            try {
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                try (FileWriter fileWriter = new FileWriter(configFile);){
                    fileWriter.write(gson.toJson((JsonElement)existingConfig));
                }
            }
            catch (IOException exception) {
                exception.printStackTrace();
                return false;
            }
        }
        return configUpdated;
    }

    private static void createDefaultConfig(File configFile) {
        try {
            configFile.getParentFile().mkdirs();
            configFile.createNewFile();
            JsonObject main = new JsonObject();
            main.addProperty("startMoney", (Number)START_MONEY);
            main.addProperty("moneyLossOnDeath", (Number)MONEY_LOSS_ON_DEATH);
            main.addProperty("paycheckEnabled", Boolean.valueOf(PAYCHECK_ENABLED));
            main.addProperty("paycheckAmount", (Number)PAYCHECK_AMOUNT);
            JsonObject villagerConfig = new JsonObject();
            villagerConfig.addProperty("tradesEnabled", Boolean.valueOf(VILLAGER_TRADES_ENABLED));
            villagerConfig.addProperty("tradeL1RawIronAmount", (Number)TRADE_L1_RAW_IRON_AMOUNT);
            villagerConfig.addProperty("tradeL2DiamondAmount", (Number)TRADE_L2_DIAMOND_AMOUNT);
            villagerConfig.addProperty("tradeL3RawCopperAmount", (Number)TRADE_L3_RAW_COPPER_AMOUNT);
            villagerConfig.addProperty("tradeL4RawIronAmount", (Number)TRADE_L4_RAW_IRON_AMOUNT);
            villagerConfig.addProperty("tradeL4DiamondAmount", (Number)TRADE_L4_DIAMOND_AMOUNT);
            villagerConfig.addProperty("tradeL5GoldenAppleAmount", (Number)TRADE_L5_GOLDEN_APPLE_AMOUNT);
            villagerConfig.addProperty("tradeL5NetherStarAmount", (Number)TRADE_L5_NETHER_STAR_AMOUNT);
            main.add("villagerConfig", (JsonElement)villagerConfig);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            try (FileWriter fileWriter = new FileWriter(configFile);){
                fileWriter.write(gson.toJson((JsonElement)main));
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }
}

