/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosmoneymod;

import de.sarocesch.sarosmoneymod.Config;
import de.sarocesch.sarosmoneymod.command.EcoCommand;
import de.sarocesch.sarosmoneymod.command.LeaderboardCommand;
import de.sarocesch.sarosmoneymod.command.MoneyCommand;
import de.sarocesch.sarosmoneymod.command.PayCommand;
import de.sarocesch.sarosmoneymod.data.BalanceManager;
import de.sarocesch.sarosmoneymod.data.BalanceMigrator;
import de.sarocesch.sarosmoneymod.init.ModBlockEntities;
import de.sarocesch.sarosmoneymod.init.ModBlocks;
import de.sarocesch.sarosmoneymod.init.ModItemGroups;
import de.sarocesch.sarosmoneymod.init.ModItems;
import de.sarocesch.sarosmoneymod.init.ModMenus;
import de.sarocesch.sarosmoneymod.listener.SignShopListenerFabric;
import de.sarocesch.sarosmoneymod.network.NetworkHandler;
import de.sarocesch.sarosmoneymod.villager.ModVillagers;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1531;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SarosMoneyModMod
implements ModInitializer {
    public static final Logger LOGGER = LogManager.getLogger(SarosMoneyModMod.class);
    public static final String MODID = "saros__money_mod";
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public void onInitialize() {
        Config.init();
        ModBlocks.registerModBlocks();
        ModBlockEntities.registerBlockEntities();
        ModItems.registerModItems();
        ModMenus.registerMenus();
        ModItemGroups.registerItemGroups();
        ModVillagers.registerVillagers();
        ModVillagers.registerTrades();
        NetworkHandler.registerC2SPackets();
        CommandRegistrationCallback.EVENT.register(EcoCommand::register);
        CommandRegistrationCallback.EVENT.register(LeaderboardCommand::register);
        CommandRegistrationCallback.EVENT.register(MoneyCommand::register);
        CommandRegistrationCallback.EVENT.register(PayCommand::register);
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            BalanceManager.setCurrentServer(server);
            BalanceMigrator.migrateOldData(server);
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> BalanceManager.setCurrentServer(null));
        ServerTickEvents.END_SERVER_TICK.register(LeaderboardCommand::onServerTick);
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> {
            if (entity instanceof class_1531) {
                LeaderboardCommand.onEntityJoin((class_1531)entity, world);
            }
        });
        SignShopListenerFabric.register();
        LOGGER.info("Saro's Money Mod initialized");
    }

    public static void queueServerWork(int tick, Runnable action) {
        workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
    }
}

